ORCA/M Asm65816 2.1.0

0001 3ADC                       Blanks off 
0002 3ADC                       String asis 
0003 3ADC
0004 3ADC              ;
0005 3ADC              ;
0006 3ADC              ;          Copyright Apple Computer, Inc. 1986-89
0007 3ADC              ;                     All rights reserved
0008 3ADC              ;                    Written by Dan Oliver
0009 3ADC              ;
0010 3ADC              ;          This module contains control definition procedures that define
0011 3ADC              ;          title bar and info bar controls.
0012 3ADC              ;
0013 3ADC              ;
0014 3ADC              ; Files needed:
0015 3ADC              ;          WINDCTL.ASM
0016 3ADC              ;            WC.MACROS
0017 3ADC              ;
0018 3ADC              ; 10/28/88  Dan O.  Handle titles and color tables as pointers or handles.
0019 3ADC              ;
0020 3ADC              ; 02/16/89  Harry   Window titles could appear pass the right side of the zoom box. 
0021 3ADC              ;                   The clip rect is now set to the left side of the zoom box or if 
0022 3ADC              ;                   no zoom box the right side of the control rect before the title 
0023 3ADC              ;                   is drawn. I also subtract a little slop so that the title does 
0024 3ADC              ;                   not end right at the edge of either the zoom box or right side of 
0025 3ADC              ;                   control rect. BRC #36699.
0026 3ADC              ;
0027 3ADC
0028 3ADC                       INCLUDE 'ALL.MACROS' 
0029 3ADC                       include 'WindMgrEquates.asm' 
0030 3ADC
0031 3ADC              ;===============================================================
0032 3ADC              ;          Control DefProc Equates
0033 3ADC              ;===============================================================
0034 3ADC              ;
0035 3ADC              ;
0036 3ADC              ; --- DefProc direct page offsets ----------------------------
0037 3ADC              ;
0038 3ADC              ctlWind  equ   1                        Pointer to window controls on.
0039 3ADC              globals  equ   ctlWind+4                Pointer to Window Manager globals.
0040 3ADC              colors   equ   globals+4                Pointer to window's color table.
0041 3ADC              rgnSize  equ   colors+4                 To make 'rect' look like a region.
0042 3ADC              cRect    equ   rgnSize+2                General RECT area.
0043 3ADC              ctlPtr   equ   cRect+8                  Pointer to locked control.
0044 3ADC              cWork    equ   ctlPtr+4                 cWork space.
0045 3ADC              DIRECTSIZE equ   cWork+10               Size of allocated direct page.
0046 3ADC              saveDpage equ   DIRECTSIZE+1            Caller's direct page.
0047 3ADC              returnAddr equ   saveDpage+2            Long return addresses.
0048 3ADC              ctlHand  equ   returnAddr+3             Handle of control.
0049 3ADC              cParam   equ   ctlHand+4                Parameter defined by defProc operation.
0050 3ADC              operation equ   cParam+4                DefProc operation to perform.
0051 3ADC              result   equ   operation+2              Result defined by defProc operation.
0052 3ADC              ;
0053 3ADC              ;
0054 3ADC              ;
0055 3ADC              ;
0056 3ADC              ; --- Document window record offsets -------------------------
0057 3ADC              ;
0058 3ADC              wtitle   equ   212                      Pointer to window's title.
0059 3ADC              wtitle_w equ   wtitle+4                 Width of title in pixels.
0060 3ADC              worgn_mask equ   wtitle_w+2             Mask for horizontal origin.
0061 3ADC              wfull    equ   worgn_mask+2             Size of window, used with ZoomWindow.
0062 3ADC              wcolor   equ   wfull+8                  Pointer to window's color table.
0063 3ADC              y_origin equ   wcolor+4                 Content's vertical offset.
0064 3ADC              x_origin equ   y_origin+2               Content's horizontal offset.
0065 3ADC              data_h   equ   x_origin+2               Height of total data area.
0066 3ADC              data_w   equ   data_h+2                 Width of total data area.
0067 3ADC              wmaxheight equ   data_w+2               Maximum height for grow window.
0068 3ADC              wmaxwidth equ   wmaxheight+2            Maximum width for grow window.
0069 3ADC              vscroll  equ   wmaxwidth+2              Amount to scroll vertically (arrows).
0070 3ADC              hscroll  equ   vscroll+2                Amount to scroll horizonally (arrows).
0071 3ADC              vpage    equ   hscroll+2                Amount to page vertically (page region).
0072 3ADC              hpage    equ   vpage+2                  Amount to page horizontally (page rgn).
0073 3ADC              wInfoRef equ   hpage+2                  Value passed to Draw Info routine.
0074 3ADC              wInfoHeight equ   wInfoRef+4            Height of information bar.
0075 3ADC              woldYOrg equ   wInfoHeight+2            Save y origin on full window.
0076 3ADC              woldXOrg equ   woldYOrg+2               Save x origin on full window.
0077 3ADC              wInfoDraw equ   woldXOrg+2              Address of routine to draw Info Bar.
0078 3ADC              DOCSIZE  equ   wInfoDraw+4              !!! Change 'port' size in WDATA.ASM !!!
0079 3ADC              ;
0080 3ADC              ;
0081 3ADC              ; --- Window color table offsets -----------------------------
0082 3ADC              ;
0083 3ADC              FRAME_CLR equ   0                       Frame's outline.
0084 3ADC              TITLE_CLR equ   FRAME_CLR+2             Title's color.
0085 3ADC              BAR_CLR  equ   TITLE_CLR+2              Title bar's initerior.
0086 3ADC              GROW_CLR equ   BAR_CLR+2                Grow box interior.
0087 3ADC              INFOR_CLR equ   GROW_CLR+2              Information bar interior.
0088 3ADC              COLORSIZ equ   INFOR_CLR+2              Size of color table.
0089 3ADC              ;
0090 3ADC              ;
0091 3ADC              ; --- Window DefProc frame offsets -----------------------------
0092 3ADC              ;
0093 3ADC              TITLEH   equ   13                       Height of title bar.
0094 3ADC              TITLEL   equ   2                        Space on left and right of title bar pattern.
0095 3ADC              TITLET   equ   3                        Space on top and bottom of title bar pattern.
0096 3ADC              ;
0097 3ADC              CLOSEL   equ   10                       Left side of window to left side of close box.
0098 3ADC              CLOSET   equ   2                        Top of window to top of close box.
0099 3ADC              CLOSEW   equ   22                       Width of close box.
0100 3ADC              CLOSEH   equ   11                       Height of close box.
0101 3ADC              ;
0102 3ADC              ;
0103 3ADC              ;
0104 3ADC              ; --- GraphPort record offsets -------------------------------
0105 3ADC              ;
0106 3ADC              boundsRect equ   $0008
0107 3ADC              clipRgn  equ   $0018
0108 3ADC              visRgn   equ   $001C
0109 3ADC              ;
0110 3ADC              ;
0111 3ADC              ; --- Control defProc operation numbers ----------------------
0112 3ADC              ;
0113 3ADC              drawCntl equ   0                        Draw the control.
0114 3ADC              calcCRect equ   drawCntl+1              Compute the drag RECT.
0115 3ADC              testCntl equ   calcCRect+1              Perform a hit test on the control.
0116 3ADC              initCntl equ   testCntl+1               Perform additional initialization.
0117 3ADC              dispCntl equ   initCntl+1               Perform additional disposal.
0118 3ADC              posCntl  equ   dispCntl+1               Called when dragging complete with delta.
0119 3ADC              thumbCntl equ   posCntl+1               Setup for dragging.
0120 3ADC              dragCntl equ   thumbCntl+1              Perform dragging.
0121 3ADC              autoTrack equ   dragCntl+1              Called while dragging.
0122 3ADC              newValue equ   autoTrack+1              Called when new value is set.
0123 3ADC              setParams equ   newValue+1              Called when min and max are set.
0124 3ADC              moveCntl equ   setParams+1              Move entire control.
0125 3ADC              recSize  equ   moveCntl+1               Return size of control's record.
0126 3ADC              ;
0127 3ADC
0128 3ADC
0129 3ADC              titlePart equ   16
0130 3ADC              closePart equ   17
0131 3ADC              zoomPart equ   18
0132 3ADC              infoPart equ   19
0133 3ADC              ;
0134 3ADC              ;
0135 3ADC              ; --- CtlFlags for title bar control -------------------------
0136 3ADC              ;
0137 3ADC              closeCtl equ   $0040                    1 = title bar has close box.
0138 3ADC              zoomCtl  equ   $0001                    1 = title bar has zoom box.
0139 3ADC
0140 3ADC
0141 3ADC
0142 3ADC              ;-----------------------------------------------
0143 3ADC              ;
0144 3ADC              ;   Imported addresses
0145 3ADC              ;
0146 3ADC              ;-----------------------------------------------
0147 3ADC
0148 3ADC                       IMPORT Fill 
0149 3ADC                       IMPORT Print 
0150 3ADC                       IMPORT Restore 
0151 3ADC                       IMPORT Return 
0152 3ADC                       IMPORT Save 
0153 3ADC                       IMPORT Set 
0154 3ADC                       IMPORT Switch 
0155 3ADC                       IMPORT longCall 
0156 3ADC                       IMPORT pushDpage 
0157 3ADC
0158 3ADC              ;-----------------------------------------------
0159 3ADC              ;
0160 3ADC              ;   Forward addresses and entries
0161 3ADC              ;
0162 3ADC              ;-----------------------------------------------
0163 3ADC
0164 3ADC                       ENTRY pushWindTitle 
0165 3ADC                       ENTRY unlockTitle 
0166 3ADC                       ENTRY colorBlack 
0167 3ADC                       ENTRY defRefCtl 
0168 3ADC                       ENTRY drawInfo 
0169 3ADC                       ENTRY drawTitle 
0170 3ADC                       ENTRY fillFrameRect 
0171 3ADC                       ENTRY getCloseCor 
0172 3ADC                       ENTRY getColorTable 
0173 3ADC                       ENTRY unlockColor 
0174 3ADC                       ENTRY getCoords 
0175 3ADC                       ENTRY getCtlRect 
0176 3ADC                       ENTRY getLineSize 
0177 3ADC                       ENTRY getWindPtr 
0178 3ADC                       ENTRY initTitle 
0179 3ADC                       ENTRY nullHandler 
0180 3ADC                       ENTRY pushLineSize 
0181 3ADC                       ENTRY pushRect 
0182 3ADC                       ENTRY set_patt 
0183 3ADC                       ENTRY shutdown 
0184 3ADC                       ENTRY smear 
0185 3ADC                       ENTRY startup 
0186 3ADC                       ENTRY testInfo 
0187 3ADC                       ENTRY testTitle 
0188 3ADC                       ENTRY titleRecSize 
0189 3ADC                       ENTRY titleValue 
0190 3ADC
0191 3ADC
0192 3ADC              ;
0193 3ADC              ;
0194 3ADC              ;===============================================================
0195 3ADC              ;          Title bar custom control defProc.
0196 3ADC              ;===============================================================
0197 3ADC              ;
0198 3ADC              ;   IN:    PUSH:LONG - space for result.
0199 3ADC              ;          PUSH:WORD - operation to perform.
0200 3ADC              ;          PUSH:LONG - additional parameter defined by operation.
0201 3ADC              ;          PUSH:LONG - handle of control.
0202 3ADC              ;
0203 3ADC                       EXPORT titleBarDefProc 
0204 3ADC              titleBarDefProc PROC 
0205 3ADC              ;
0206 3ADC              ;
0207 3ADC              ;
0208 3ADC 20 D1 3E              jsr   startup                  Allocate direct page.
0209 3ADF              ;
0210 3ADF 64 35                 stz   <result                  Initialize result to null.
0211 3AE1 64 37                 stz   <result+2
0212 3AE3              ;
0213 3AE3 A5 33                 lda   <operation
0214 3AE5 C9 0D 00              cmp   #recSize+1
0215 3AE8 B0 05                 bcs   shutdown
0216 3AEA 0A                    asl   a
0217 3AEB AA                    tax   
0218 3AEC FC 02 3B              jsr   (tHandlers,x)
0219 3AEF              ;
0220 3AEF              ;
0221 3AEF              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0222 3AEF              ;       Cleanup and exit control defProc.
0223 3AEF              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0224 3AEF
0225 3AEF              ;
0226 3AEF                       ENTRY shutdown 
0227 3AEF              shutdown                                ;       
0228 3AEF              ;
0229 3AEF A5 29                 lda   <returnAddr+1            Move return address over inputs.
0230 3AF1 85 33                 sta   <result-2
0231 3AF3 A5 28                 lda   <returnAddr
0232 3AF5 85 32                 sta   <result-3
0233 3AF7              ;
0234 3AF7 A6 26                 ldx   <saveDpage               Get original direct page.
0235 3AF9              ;
0236 3AF9 3B                    tsc                            Free allocated direct page and inputs.
0237 3AFA 18                    clc   
0238 3AFB 69 31 00              adc   #result-4
0239 3AFE 1B                    tcs   
0240 3AFF              ;
0241 3AFF 8A                    txa                            Restore caller's direct page.
0242 3B00 5B                    tcd   
0243 3B01 6B                    rtl                            Return to defProc caller.
0244 3B02              ;
0245 3B02              ;
0246 3B02 1C 3B        tHandlers DC W:drawTitle                0 drawCtl
0247 3B04 90 3C                 DC W:nullHandler               1 calcCRect
0248 3B06 9F 3D                 DC W:testTitle                 2 testCtl
0249 3B08 66 3D                 DC W:initTitle                 3 initCtl
0250 3B0A 90 3C                 DC W:nullHandler               4 dispCtl
0251 3B0C 90 3C                 DC W:nullHandler               5 posCtl
0252 3B0E 90 3C                 DC W:nullHandler               6 thumbCtl
0253 3B10 90 3C                 DC W:nullHandler               7 dragCtl
0254 3B12 90 3C                 DC W:nullHandler               8 autoTrack
0255 3B14 66 3D                 DC W:titleValue                9 newValue
0256 3B16 90 3C                 DC W:nullHandler               A setParams
0257 3B18 90 3C                 DC W:nullHandler               B moveCtl
0258 3B1A FA 3D                 DC W:titleRecSize              C recSize
0259 3B1C              ;
0260 3B1C                       ENDP 
0261 3B1C              ;
0262 3B1C              ;
0263 3B1C              ;===============================================================
0264 3B1C              ;          Operation: drawCtl
0265 3B1C              ;===============================================================
0266 3B1C              ;
0267 3B1C              ;   IN:    <cParam = part code to draw, zero if whole control.
0268 3B1C              ;
0269 3B1C              drawTitle PROC 
0270 3B1C              ;
0271 3B1C                                                      ;using equates
0272 3B1C              ;
0273 3B1C              flags    equ   cWork
0274 3B1C              minX     equ   flags+2
0275 3B1C              active   equ   minX+2
0276 3B1C              iconNumber equ   active+2
0277 3B1C              ;
0278 3B1C              ;
0279 3B1C 20 EB 3E              jsr   defRefCtl                <ctlPtr = pointer to control record.
0280 3B1F 20 F7 3E              jsr   getCtlRect               <cRect = control's bounds.
0281 3B22 20 E8 40              jsr   getWindPtr               <ctlWind = pointer to window.
0282 3B25 20 08 3F              jsr   getColorTable            <colors = pointer to color table.
0283 3B28              ;
0284 3B28 A0 D2 00              ldy   #wFrame                  Active state of controls same as
0285 3B2B B7 01                 lda   [<ctlWind],y             window's state.
0286 3B2D 29 01 00              and   #F_HILITED               TRUE = frame is highlighted.
0287 3B30 85 1F                 sta   <active
0288 3B32              ;
0289 3B32              ;
0290 3B32              ; --- Set colors ---------------------------------------------
0291 3B32              ;
0292 3B32 A0 10 00              ldy   #ctlFlag
0293 3B35 B7 17                 lda   [<ctlPtr],y
0294 3B37 85 1B                 sta   <flags
0295 3B39              ;
0296 3B39 F4 04 00              pea   4                        Smear text colors.
0297 3B3C A2 04 98 22           _SetFontFlags 
0298 3B43              ;
0299 3B43 A0 02 00              ldy   #TITLE_CLR               Inactive title bar color.
0300 3B46 B7 09                 lda   [<colors],y
0301 3B48 EB                    xba   
0302 3B49 A6 1F                 ldx   <active                  Is control active?
0303 3B4B F0 05                 beq   ok2
0304 3B4D A0 04 00              ldy   #BAR_CLR                 Lay down title bar background
0305 3B50 B7 09                 lda   [<colors],y              for an active window.
0306 3B52 20 C6 40     ok2      jsr   smear                    Smear color into all 4 nibbles.
0307 3B55 48                    pha                            Save background color.
0308 3B56              ;
0309 3B56 48                    pha                            Pass color of text's background.
0310 3B57 A2 04 A2 22           _SetBackColor                  Set title, close, zoom background color.
0311 3B5E              ;
0312 3B5E              ;
0313 3B5E A0 02 00              ldy   #TITLE_CLR               Set color of text
0314 3B61 B7 09                 lda   [<colors],y
0315 3B63 A6 1F                 ldx   <active                  Is control active?
0316 3B65 D0 04                 bne   ok3
0317 3B67 4A                    lsr   a                        Get its inactive color.
0318 3B68 4A                    lsr   a
0319 3B69 4A                    lsr   a
0320 3B6A 4A                    lsr   a
0321 3B6B 20 C6 40     ok3      jsr   smear                    Smear color into all 4 nibbles.
0322 3B6E 48                    pha   
0323 3B6F A2 04 A0 22           _SetForeColor                  Set color of text.
0324 3B76              ;
0325 3B76              ;
0326 3B76              ;---------------------------------------------------
0327 3B76              ;          Fill and frame title bar.
0328 3B76              ;---------------------------------------------------
0329 3B76              ;
0330 3B76 F4 00 00              pea   0                        Set text mode to copy.
0331 3B79 A2 04 9C 22           _SetTextMode 
0332 3B80              ;
0333 3B80 68                    pla                            Restore background color.
0334 3B81 A4 2F                 ldy   <cParam                  Whole control?
0335 3B83 F0 03                 beq   @DrawWhole
0336 3B85 82 BB 00              brl   drawClose
0337 3B88              ;
0338 3B88 29 F0 00     @DrawWhole and   #$00F0                 Put color into proper nibble for fill.
0339 3B8B 48                    pha                            Save fill color.
0340 3B8C              ;
0341 3B8C A0 00 00              ldy   #FRAME_CLR               Pass outline color.
0342 3B8F B7 09                 lda   [<colors],y
0343 3B91 29 F0 00              and   #$00F0
0344 3B94 7A                    ply                            Pass fill color.
0345 3B95 20 77 3F              jsr   fillFrameRect            Draw blank title bar.
0346 3B98              ;
0347 3B98              ;
0348 3B98 A5 1F                 lda   <active                  If title bar is inactive don't fill
0349 3B9A F0 33                 beq   printTitle               with active pattern.
0350 3B9C              ;
0351 3B9C A0 04 00              ldy   #BAR_CLR                 Get title bar pattern.
0352 3B9F B7 09                 lda   [<colors],y
0353 3BA1 29 00 FF              and   #$FF00                   Solid pattern?
0354 3BA4 F0 29                 beq   printTitle               If solid, no foreground to fill.
0355 3BA6              ;
0356 3BA6 20 81 40              jsr   pushRect                 Indent cRECT for pattern fill.
0357 3BA9 20 DF 40              jsr   getLineSize              a = width of lines, x = height of lines.
0358 3BAC 0A                    asl   a
0359 3BAD E8                    inx   
0360 3BAE 48                    pha                            Pass width.
0361 3BAF DA                    phx                            Pass height.
0362 3BB0 A2 04 4C 22           _InsetRect 
0363 3BB7              ;
0364 3BB7 20 81 40              jsr   pushRect                 Pass address of 'cRect'.
0365 3BBA A0 04 00              ldy   #BAR_CLR                 Get title bar pattern.
0366 3BBD B7 09                 lda   [<colors],y
0367 3BBF A8                    tay   
0368 3BC0 20 DB 3F              jsr   set_patt                 Generate pattern.
0369 3BC3 DA                    phx                            Pass pointer to pattern.
0370 3BC4 5A                    phy   
0371 3BC5 A2 04 57 22           _FillRect                      Fill with highlight pattern.
0372 3BCC              ;
0373 3BCC 20 F7 3E              jsr   getCtlRect               <cRect = control's bounds.
0374 3BCF              ;
0375 3BCF              ;
0376 3BCF              ; ------- Print title in title bar -----------------------
0377 3BCF              ; 
0378 3BCF              ;  IN: <cRect = control's bounds
0379 3BCF              ;      <ctlPtr = ptr to title's control record
0380 3BCF              ; OUT: <cRect = trashed
0381 3BCF              ;
0382 3BCF 20 EB 3E     printTitle jsr   defRefCtl              <ctlPtr = pointer to control record.
0383 3BD2              ;
0384 3BD2 A5 1B                 lda   <flags                   Check if there is a zoom box
0385 3BD4 29 01 00              and   #zoomctl
0386 3BD7 F0 0F                 beq   NoZoom
0387 3BD9
0388 3BD9 A2 02 00              ldx   #2                       There is a zoom box, so get the coordinates for it
0389 3BDC FC C2 40              jsr   (getcoords,x)            Coordinates are put into <cRect
0390 3BDF A5 11                 lda   <cRect+x1                We just need left side
0391 3BE1 48                    pha   
0392 3BE2 20 F7 3E              jsr   getCtlRect               <cRect = control's bounds
0393 3BE5 68                    pla   
0394 3BE6 80 02                 bra   storeit
0395 3BE8
0396 3BE8 A5 15        NoZoom   lda   <cRect+x2                Compute right side of title
0397 3BEA 38           storeit  sec   
0398 3BEB E9 08 00              sbc   #8                       Subtract a little slop
0399 3BEE 85 15                 sta   <cRect+x2
0400 3BF0
0401 3BF0 A0 12 00              ldy   #ctlValue
0402 3BF3 B7 17                 lda   [<ctlPtr],y              Get left side of title
0403 3BF5 85 11                 sta   <cRect+x1
0404 3BF7
0405 3BF7 A5 15                 lda   <cRect+x2
0406 3BF9 38                    sec   
0407 3BFA E5 11                 sbc   <cRect+x1
0408 3BFC A0 D8 00              ldy   #wtitle_w
0409 3BFF D7 01                 cmp   [<ctlwind],y
0410 3C01 B0 08                 bcs   TitleFits
0411 3C03
0412 3C03 20 91 3C              jsr   MakeTitleFit             a-reg = space we have to work with
0413 3C06 F4 00 00              pea   $0000                    Flag for DrawString that says orig title has been chopped
0414 3C09 80 03                 bra   around
0415 3C0B
0416 3C0B F4 FF FF     TitleFits pea   $FFFF                   Flag for DrawString to tell us to use original title
0417 3C0E A0 12 00     around   ldy   #ctlValue                Pass x position.
0418 3C11 B7 17                 lda   [<ctlPtr],y
0419 3C13 48                    pha   
0420 3C14 A0 04 00              ldy   #titleYPos               Pass y position.
0421 3C17 B7 05                 lda   [<globals],y
0422 3C19 48                    pha   
0423 3C1A A2 04 3A 22           _MoveTo                        Set pen's starting position.
0424 3C21
0425 3C21 20 EB 3E              jsr   defRefCtl                <ctlPtr = pointer to control record.
0426 3C24
0427 3C24 68                    pla   
0428 3C25 30 0F                 bmi   TitleGood
0429 3C27 A5 05                 lda   <globals
0430 3C29 A6 07                 ldx   <globals+2
0431 3C2B 18                    clc   
0432 3C2C 69 D2 01              adc   #WindTitle
0433 3C2F 90 01                 bcc   @noCarry
0434 3C31 E8                    inx   
0435 3C32 DA           @noCarry phx   
0436 3C33 48                    pha   
0437 3C34 80 03                 bra   drawit
0438 3C36
0439 3C36 20 F6 42     TitleGood jsr   pushWindTitle           Pass pointer to window's title.
0440 3C39 A2 04 A5 22  drawit   _DrawString                    Print window's title.
0441 3C40
0442 3C40 20 2E 43              jsr   unlockTitle              Leave title unlocked.
0443 3C43
0444 3C43              ;
0445 3C43              ;-------------------------------------
0446 3C43              ;          Draw close box.
0447 3C43              ;-------------------------------------
0448 3C43              ;
0449 3C43 A5 1F        drawClose lda   <active                 If title bar is inactive then done.
0450 3C45 F0 3C                 beq   exit
0451 3C47              ;
0452 3C47 20 EB 3E              jsr   defRefCtl                <ctlPtr = pointer to control record.
0453 3C4A              ;
0454 3C4A A0 11 00              ldy   #ctlHilite               Set hilite flag.
0455 3C4D B7 17                 lda   [<ctlPtr],y
0456 3C4F 29 FF 00              and   #$00FF
0457 3C52 85 31                 sta   <cParam+2
0458 3C54              ;
0459 3C54 A5 2F                 lda   <cParam                  Draw whole control?
0460 3C56 F0 05                 beq   ok5
0461 3C58 C9 11 00              cmp   #closePart               Draw just the close box?
0462 3C5B D0 10                 bne   drawZoom
0463 3C5D              ;
0464 3C5D A5 1B        ok5      lda   <flags
0465 3C5F 29 40 00              and   #closeCtl                Is there a close box?
0466 3C62 F0 09                 beq   drawZoom
0467 3C64              ;
0468 3C64 A9 00 00              lda   #0                       Draw close box.
0469 3C67 20 12 3D              jsr   drawBox
0470 3C6A 20 EB 3E              jsr   defRefCtl                <ctlPtr = pointer to control record.
0471 3C6D              ;
0472 3C6D              ;
0473 3C6D              ;-------------------------------------
0474 3C6D              ;          Draw zoom box.
0475 3C6D              ;-------------------------------------
0476 3C6D              ;
0477 3C6D A5 2F        drawZoom lda   <cParam                  Draw entire window?
0478 3C6F F0 05                 beq   ok4
0479 3C71 C9 12 00              cmp   #zoomPart                Draw just the close box?
0480 3C74 D0 0D                 bne   exit
0481 3C76              ;
0482 3C76 A5 1B        ok4      lda   <flags
0483 3C78 29 01 00              and   #zoomCtl                 Is there a zoom box?
0484 3C7B F0 06                 beq   exit
0485 3C7D              ;
0486 3C7D A9 02 00              lda   #2                       Draw zoom box.
0487 3C80 20 12 3D              jsr   drawBox
0488 3C83              ;
0489 3C83              ;
0490 3C83 F4 00 00     exit     pea   0                        Restore to normal.
0491 3C86 A2 04 98 22           _SetFontFlags 
0492 3C8D              ;
0493 3C8D 20 41 3F              jsr   unlockColor              Leave color table unlocked.
0494 3C90              ;
0495 3C90                       ENTRY nullHandler 
0496 3C90              nullHandler                             ;       
0497 3C90 60                    rts   
0498 3C91
0499 3C91
0500 3C91              ;===============================================================
0501 3C91              ;                   MakeTitleFit
0502 3C91              ;===============================================================
0503 3C91              ;
0504 3C91              ;   IN:    a-reg    = amount of space we actually have to work with
0505 3C91              ;
0506 3C91              ;  OUT:    #windTitle offset from globals data area contains new window title
0507 3C91
0508 3C91                       ENTRY MakeTitleFit 
0509 3C91              MakeTitleFit  
0510 3C91                             DefineStack  
0511 3C91              OrigD          word  
0512 3C91              Count          word  
0513 3C91              NextCharSize   word  
0514 3C91              DestTitle      long  
0515 3C91              OrigTitle      long  
0516 3C91              TotalSpace     word  
0517 3C91
0518 3C91
0519 3C91 48                    pha                            Space we have to work with (TotalSpace)
0520 3C92 20 F6 42              jsr   pushWindTitle            Get pointer to window title
0521 3C95 A5 05                 lda   <globals                 Get pointer to where new and improved title will go
0522 3C97 A6 07                 ldx   <globals+2               (space for this is on the window mgr's global data area)
0523 3C99 18                    clc   
0524 3C9A 69 D2 01              adc   #WindTitle
0525 3C9D 90 01                 bcc   @Skip
0526 3C9F E8                    inx   
0527 3CA0 DA           @Skip    phx   
0528 3CA1 48                    pha   
0529 3CA2 48                    pha                            Space to hold next character in title
0530 3CA3 48                    pha                            Counter
0531 3CA4 0B                    phd                            Save original direct page
0532 3CA5
0533 3CA5 3B                    tsc                            Turn stack into direct page
0534 3CA6 5B                    tcd   
0535 3CA7
0536 3CA7              ;
0537 3CA7              ; --- Subtract width of elipsis and space character from total width -------------------
0538 3CA7              ;
0539 3CA7 A9 C9 20              lda   #$20C9
0540 3CAA 85 05                 sta   <NextCharSize
0541 3CAC
0542 3CAC F4 00 00              pea   0                        Space for result
0543 3CAF F4 00 00              pea   0                        Pointer to text
0544 3CB2 7B                    tdc   
0545 3CB3 18                    clc   
0546 3CB4 69 05 00              adc   #NextCharSize
0547 3CB7 48                    pha   
0548 3CB8 F4 02 00              pea   2                        length of string
0549 3CBB A2 04 AB 22           _TextWidth 
0550 3CC2 A5 0F                 lda   <TotalSpace
0551 3CC4 38                    sec   
0552 3CC5 E3 01                 sbc   1,s
0553 3CC7 85 0F                 sta   <TotalSpace
0554 3CC9 68                    pla                            Get length off of stack
0555 3CCA
0556 3CCA 64 03                 stz   <count
0557 3CCC
0558 3CCC A4 03        lop1     ldy   <count
0559 3CCE C8                    iny                            Bump <count and get size of next character
0560 3CCF B7 0B                 lda   [<OrigTitle],y
0561 3CD1 29 FF 00              and   #$00FF
0562 3CD4 48                    pha                            Save next char in window title on stack
0563 3CD5 48                    pha                            Space for result
0564 3CD6 48                    pha                            Character that we want width for
0565 3CD7 A2 04 A8 22           _CharWidth 
0566 3CDE 68                    pla   
0567 3CDF 85 05                 sta   <NextCharSize
0568 3CE1 A5 0F                 lda   <TotalSpace              Subtract nextchar from total width we have to fit title in
0569 3CE3 38                    sec   
0570 3CE4 E5 05                 sbc   <NextCharSize
0571 3CE6 10 03                 bpl   KeepInserting            Can't fit any more characters
0572 3CE8 68                    pla                            Clean up stack first
0573 3CE9 80 0B                 bra   doneInserting
0574 3CEB 85 0F        KeepInserting sta   <TotalSpace
0575 3CED E6 03                 inc   <count
0576 3CEF A4 03                 ldy   <count
0577 3CF1 68                    pla                            Get next char off stack
0578 3CF2 97 07                 sta   [<DestTitle],y
0579 3CF4 80 D6                 bra   lop1
0580 3CF6
0581 3CF6 A9 C9 20     doneInserting lda   #$20C9              Add '...' character to end of window's title
0582 3CF9 A4 03                 ldy   <count
0583 3CFB C8                    iny   
0584 3CFC 97 07                 sta   [<DestTitle],y
0585 3CFE C8                    iny   
0586 3CFF 84 03                 sty   <count
0587 3D01 A7 0B                 lda   [<OrigTitle]             Store new length of title
0588 3D03 29 00 FF              and   #$FF00
0589 3D06 05 03                 ora   <count                   'OR' count in
0590 3D08 87 07                 sta   [<DestTitle]
0591 3D0A
0592 3D0A 2B                    pld                            Restore our stack.
0593 3D0B 3B                    tsc   
0594 3D0C 18                    clc   
0595 3D0D 69 0E 00              adc   #14
0596 3D10 1B                    tcs   
0597 3D11
0598 3D11 60                    rts   
0599 3D12
0600 3D12
0601 3D12              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0602 3D12
0603 3D12              ;          Draw close or zoom box.
0604 3D12              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0605 3D12              ;
0606 3D12              ;   IN:    cParam+2 = FALSE if normal, TRUE if selected.
0607 3D12              ;          a = 0 draw close box, 2 draw zoom box.
0608 3D12              ;
0609 3D12              ;          Icon numbers are:  0 = normal close box.
0610 3D12              ;                             1 = selected close or zoom box.
0611 3D12              ;                             2 = normal zoom box.
0612 3D12              ;
0613 3D12              ;  OUT:    <cRect = trash.
0614 3D12              ;
0615 3D12 AA           drawBox  tax                            Save box kind.
0616 3D13 A4 31                 ldy   <cParam+2
0617 3D15 F0 03                 beq   store100                 If normal, use icon number.
0618 3D17 A9 01 00              lda   #1                       Use selected icon.
0619 3D1A 85 21        store100 sta   <iconNumber              Save icon number.
0620 3D1C              ;
0621 3D1C              ;
0622 3D1C              ; --- Get coordinates of box ---------------------------------
0623 3D1C              ;
0624 3D1C FC C2 40              jsr   (getCoords,x)            x = 0 if close box, 2 if zoom.
0625 3D1F              ;
0626 3D1F              ;
0627 3D1F              ; --- Draw the box -------------------------------------------
0628 3D1F              ;
0629 3D1F 48                    pha   
0630 3D20 48                    pha   
0631 3D21 A2 04 D1 22           _GetFontID                     Save current font ID.
0632 3D28 48                    pha   
0633 3D29 48                    pha   
0634 3D2A A2 04 95 22           _GetFont                       Save current font.
0635 3D31              ;
0636 3D31 A0 10 00              ldy   #windIconFont+2          Pass address of font pointer (handle).
0637 3D34 B7 05                 lda   [<globals],y
0638 3D36 48                    pha   
0639 3D37 88                    dey   
0640 3D38 88                    dey   
0641 3D39 B7 05                 lda   [<globals],y
0642 3D3B 48                    pha   
0643 3D3C A2 04 94 22           _SetFont                       Switch to icon font.
0644 3D43              ;
0645 3D43 D4 11                 pei   <cRect+x1                Move pen to where icon should be.
0646 3D45 D4 0F                 pei   <cRect+y1
0647 3D47 A2 04 3A 22           _MoveTo 
0648 3D4E              ;
0649 3D4E D4 21                 pei   <iconNumber              Pass character to print.
0650 3D50 A2 04 A4 22           _DrawChar                      Print icon.
0651 3D57              ;
0652 3D57 A2 04 94 22           _SetFont                       Restore original font.
0653 3D5E A2 04 D0 22           _SetFontID                     Restore orginal font ID.
0654 3D65 60                    rts   
0655 3D66              ;
0656 3D66                       ENDP 
0657 3D66              ;
0658 3D66              ;
0659 3D66              ;===============================================================
0660 3D66              ;          Operation: initCtl
0661 3D66              ;===============================================================
0662 3D66              ;
0663 3D66              ;   IN:    wtitle_w = width of title string.
0664 3D66              ;
0665 3D66              ;  OUT:    ctlValue = x position of title.
0666 3D66              ;
0667 3D66              *initTitle  PRIVATE
0668 3D66              initTitle PROC 
0669 3D66              ;
0670 3D66                                                      ;using equates
0671 3D66              ;
0672 3D66              minX     equ   cWork
0673 3D66
0674 3D66
0675 3D66                       ENTRY titleValue 
0676 3D66              titleValue  
0677 3D66
0678 3D66 20 EB 3E              jsr   defRefCtl                <ctlPtr = pointer to control record.
0679 3D69 20 E8 40              jsr   getWindPtr               <ctlWind = pointer to window.
0680 3D6C              ;
0681 3D6C              ;
0682 3D6C              ; --- Set ctlValue field -------------------------------------
0683 3D6C              ;
0684 3D6C 64 15                 stz   <cRect+x2                Use left side of window if no close box.
0685 3D6E
0686 3D6E A0 10 00              ldy   #ctlFlag                 Is there a close box?
0687 3D71 B7 17                 lda   [<ctlPtr],y
0688 3D73 29 40 00              and   #closeCtl
0689 3D76 F0 03                 beq   skip1
0690 3D78
0691 3D78 20 A7 40              jsr   getCloseCor              Use right side of close box.
0692 3D7B
0693 3D7B A5 15        skip1    lda   <cRect+x2                Compute minimum x1 position of title.
0694 3D7D 18                    clc   
0695 3D7E 69 08 00              adc   #8
0696 3D81 85 1B                 sta   <minX
0697 3D83
0698 3D83 20 F7 3E              jsr   getCtlRect               <cRect = control's bounds.
0699 3D86
0700 3D86 A5 15                 lda   <cRect+x2                Compute width of title bar.
0701 3D88 38                    sec   
0702 3D89 E5 11                 sbc   <cRect+x1
0703 3D8B A0 D8 00              ldy   #wtitle_w                Subtract width of title.
0704 3D8E F7 01                 sbc   [<ctlWind],y
0705 3D90 90 05                 bcc   tooBig                   Title won't fit?
0706 3D92
0707 3D92 4A                    lsr   a                        Center the title.
0708 3D93 C5 1B                 cmp   <minX                    To the left of the close box?
0709 3D95 B0 02                 bcs   store1
0710 3D97
0711 3D97 A5 1B        tooBig   lda   <minX                    Use minimum x position.
0712 3D99
0713 3D99 A0 12 00     store1   ldy   #ctlValue                Store x position in ctlValue.
0714 3D9C 97 17                 sta   [<ctlPtr],y
0715 3D9E
0716 3D9E 60                    rts   
0717 3D9F                       ENDP 
0718 3D9F
0719 3D9F
0720 3D9F              ;===============================================================
0721 3D9F              ;          Operation: testCtl
0722 3D9F              ;===============================================================
0723 3D9F
0724 3D9F              testTitle PROC 
0725 3D9F
0726 3D9F              boxNumber equ   cWork
0727 3D9F
0728 3D9F 20 EB 3E              jsr   defRefCtl                <ctlPtr = pointer to control record.
0729 3DA2 20 E8 40              jsr   getWindPtr               <ctlWind = pointer to window.
0730 3DA5
0731 3DA5 A9 10 00              lda   #titlePart               Return title bar part code, just in case.
0732 3DA8 85 35                 sta   <result
0733 3DAA
0734 3DAA A0 D2 00              ldy   #wFrame                  Is the title bar active?
0735 3DAD B7 01                 lda   [<ctlWind],y
0736 3DAF 29 01 00              and   #F_HILITED
0737 3DB2 F0 2F                 beq   exit
0738 3DB4
0739 3DB4              ;
0740 3DB4              ; --- Check for hit on close box --------------------------------
0741 3DB4              ;
0742 3DB4 A0 10 00              ldy   #ctlFlag
0743 3DB7 B7 17                 lda   [<ctlPtr],y
0744 3DB9 29 40 00              and   #closeCtl                Is there a close box?
0745 3DBC F0 0E                 beq   ckZoom
0746 3DBE              ;
0747 3DBE A2 00 00              ldx   #0                       Check if point in close box.
0748 3DC1 20 E4 3D              jsr   checkBox
0749 3DC4 F0 06                 beq   ckZoom                   Inside?
0750 3DC6              ;
0751 3DC6 A9 11 00              lda   #closePart               Return close box part code.
0752 3DC9 85 35                 sta   <result
0753 3DCB 60                    rts   
0754 3DCC              ;
0755 3DCC              ;
0756 3DCC              ; --- Check for hit on zoom box --------------------------------
0757 3DCC              ;
0758 3DCC A0 10 00     ckZoom   ldy   #ctlFlag
0759 3DCF B7 17                 lda   [<ctlPtr],y
0760 3DD1 29 01 00              and   #zoomCtl                 Is there a zoom box?
0761 3DD4 F0 0D                 beq   exit
0762 3DD6              ;
0763 3DD6 A2 02 00              ldx   #2                       Check if point in zoom box.
0764 3DD9 20 E4 3D              jsr   checkBox
0765 3DDC F0 05                 beq   exit                     Inside?
0766 3DDE              ;
0767 3DDE A9 12 00              lda   #zoomPart                Return zoom box part code.
0768 3DE1 85 35                 sta   <result
0769 3DE3 60           exit     rts   
0770 3DE4
0771 3DE4
0772 3DE4              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0773 3DE4
0774 3DE4              ;          Check if point in box.
0775 3DE4              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0776 3DE4              ;
0777 3DE4              ;   IN:    x = 0 to check close box, 2 to check zoom box.
0778 3DE4              ;          <cParam = point to check.
0779 3DE4              ;
0780 3DE4              ;  OUT:    BEQ if point not in box.
0781 3DE4              ;
0782 3DE4 FC C2 40     checkBox jsr   (getCoords,x)            x = 0 if close box, 2 if zoom.
0783 3DE7
0784 3DE7 48                    pha                            Space for return value.
0785 3DE8 A9 2F 00              lda   #cParam                  Pass pointer to point to check.
0786 3DEB 20 64 8F              jsr   pushDpage
0787 3DEE 20 81 40              jsr   pushRect                 Pass RECT to check.
0788 3DF1 A2 04 4F 22           _PtInRect 
0789 3DF8 68                    pla   
0790 3DF9 60                    rts   
0791 3DFA
0792 3DFA                       ENDP 
0793 3DFA
0794 3DFA
0795 3DFA              ;===============================================================
0796 3DFA              ;          Operation: recSize
0797 3DFA              ;===============================================================
0798 3DFA              ;
0799 3DFA              titleRecSize PROC 
0800 3DFA
0801 3DFA A9 28 00              lda   #ctlRecSize              Return size of standard control record.
0802 3DFD 85 35                 sta   <result
0803 3DFF 60                    rts   
0804 3E00                       ENDP 
0805 3E00
0806 3E00
0807 3E00              ;===============================================================
0808 3E00              ;          Info bar custom control defProc.
0809 3E00              ;===============================================================
0810 3E00              ;
0811 3E00              ;   IN:    PUSH:LONG - space for result.
0812 3E00              ;          PUSH:WORD - operation to perform.
0813 3E00              ;          PUSH:LONG - additional parameter defined by operation.
0814 3E00              ;          PUSH:LONG - handle of control.
0815 3E00              ;
0816 3E00                       EXPORT infoBarDefProc 
0817 3E00              infoBarDefProc PROC 
0818 3E00
0819 3E00 20 D1 3E              jsr   startup                  Allocate direct page.
0820 3E03
0821 3E03 64 35                 stz   <result                  Initialize result to null.
0822 3E05 64 37                 stz   <result+2
0823 3E07
0824 3E07 A5 33                 lda   <operation               Is operation in range?
0825 3E09 C9 0D 00              cmp   #recSize+1
0826 3E0C B0 05                 bcs   exit
0827 3E0E 0A                    asl   a
0828 3E0F AA                    tax   
0829 3E10 FC 16 3E              jsr   (iHandlers,x)
0830 3E13 82 D9 FC     exit     brl   shutdown
0831 3E16
0832 3E16 30 3E        iHandlers DC W:drawInfo                 drawCtl
0833 3E18 90 3C                 DC W:nullHandler               calcCRect
0834 3E1A CB 3E                 DC W:testInfo                  testCtl
0835 3E1C 90 3C                 DC W:nullHandler               initCtl
0836 3E1E 90 3C                 DC W:nullHandler               dispCtl
0837 3E20 90 3C                 DC W:nullHandler               posCtl
0838 3E22 90 3C                 DC W:nullHandler               thumbCtl
0839 3E24 90 3C                 DC W:nullHandler               dragCtl
0840 3E26 90 3C                 DC W:nullHandler               autoTrack
0841 3E28 90 3C                 DC W:nullHandler               newValue
0842 3E2A 90 3C                 DC W:nullHandler               setParams
0843 3E2C 90 3C                 DC W:nullHandler               moveCtl
0844 3E2E FA 3D                 DC W:titleRecSize              C recSize
0845 3E30
0846 3E30                       ENDP 
0847 3E30
0848 3E30
0849 3E30              ;====================================
0850 3E30              ;          Draw info bar.
0851 3E30              ;====================================
0852 3E30              ;
0853 3E30              drawInfo PROC 
0854 3E30              ;
0855 3E30              ;
0856 3E30              portPtr  equ   cWork
0857 3E30              dummyHand equ   portPtr+4
0858 3E30              ;
0859 3E30              ;
0860 3E30 20 EB 3E              jsr   defRefCtl                <ctlPtr = pointer to control record.
0861 3E33 20 F7 3E              jsr   getCtlRect               <cRect = control's bounds.
0862 3E36 20 E8 40              jsr   getWindPtr               <ctlWind = pointer to window.
0863 3E39 20 08 3F              jsr   getColorTable            <colors = pointer to color table.
0864 3E3C              ;
0865 3E3C A0 08 00              ldy   #INFOR_CLR               Information bar pattern.
0866 3E3F B7 09                 lda   [<colors],y
0867 3E41 29 F0 00              and   #$00F0                   Force solid.
0868 3E44 48                    pha                            Save fill color.
0869 3E45              ;
0870 3E45 A0 00 00              ldy   #FRAME_CLR               Pass outline color.
0871 3E48 B7 09                 lda   [<colors],y
0872 3E4A 29 F0 00              and   #$00F0
0873 3E4D 7A                    ply                            Pass fill color.
0874 3E4E 20 77 3F              jsr   fillFrameRect            Fill and frame 'rect'.
0875 3E51              ;
0876 3E51 20 81 40              jsr   pushRect
0877 3E54 20 D7 40              jsr   pushLineSize             Push size of lines.
0878 3E57 A2 04 4C 22           _InsetRect 
0879 3E5E              ;
0880 3E5E 20 EB 3E              jsr   defRefCtl                <ctlPtr = pointer to control record.
0881 3E61 A0 04 00              ldy   #ctlOwner                Get pointer to owner window.
0882 3E64 B7 17                 lda   [<ctlPtr],y
0883 3E66 85 1B                 sta   <portPtr
0884 3E68 C8                    iny   
0885 3E69 C8                    iny   
0886 3E6A B7 17                 lda   [<ctlPtr],y
0887 3E6C 85 1D                 sta   <portPtr+2
0888 3E6E              ;
0889 3E6E A0 1E 00              ldy   #wPort+clipRgn+2         Save window's clip region handle.
0890 3E71 B7 1B                 lda   [<portPtr],y
0891 3E73 48                    pha   
0892 3E74 A9 00 00              lda   #0                       Replace with my dummy handle.
0893 3E77 97 1B                 sta   [<portPtr],y
0894 3E79 88                    dey   
0895 3E7A 88                    dey   
0896 3E7B B7 1B                 lda   [<portPtr],y
0897 3E7D 48                    pha   
0898 3E7E 7B                    tdc   
0899 3E7F 18                    clc   
0900 3E80 69 1F 00              adc   #dummyHand
0901 3E83 97 1B                 sta   [<portPtr],y
0902 3E85              ;
0903 3E85 A9 0A 00              lda   #10                      Make <rect look like a region.
0904 3E88 85 0D                 sta   <rgnSize
0905 3E8A              ;
0906 3E8A 7B                    tdc                            Compute pointer to dummy region.
0907 3E8B 18                    clc   
0908 3E8C 69 0D 00              adc   #rgnSize
0909 3E8F 85 1F                 sta   <dummyHand               Make dummy region handle.
0910 3E91 64 21                 stz   <dummyHand+2
0911 3E93              ;
0912 3E93              ;
0913 3E93 20 81 40              jsr   pushRect                 Pass information bar RECT.
0914 3E96              ;
0915 3E96 A0 FE 00              ldy   #wInfoRef+2              Pass value in wInfoRef.
0916 3E99 B7 01                 lda   [<ctlWind],y
0917 3E9B 48                    pha   
0918 3E9C 88                    dey   
0919 3E9D 88                    dey   
0920 3E9E B7 01                 lda   [<ctlWind],y
0921 3EA0 48                    pha   
0922 3EA1              ;
0923 3EA1 A6 03                 ldx   <ctlWind+2               Pass pointer to window port.
0924 3EA3 A5 01                 lda   <ctlWind
0925 3EA5 18                    clc   
0926 3EA6 69 04 00              adc   #4
0927 3EA9 90 01                 bcc   store1
0928 3EAB E8                    inx   
0929 3EAC DA           store1   phx   
0930 3EAD 48                    pha   
0931 3EAE              ;
0932 3EAE A0 07 01              ldy   #wInfoDraw+1
0933 3EB1 B7 01                 lda   [<ctlWind],y
0934 3EB3 AA                    tax   
0935 3EB4 88                    dey   
0936 3EB5 B7 01                 lda   [<ctlWind],y
0937 3EB7 22 67 22 FD           jsl   longCall                 Call draw routine.
0938 3EBB              ;
0939 3EBB A0 1C 00              ldy   #wPort+clipRgn           Retore clip handle.
0940 3EBE 68                    pla   
0941 3EBF 97 1B                 sta   [<portPtr],y
0942 3EC1 C8                    iny   
0943 3EC2 C8                    iny   
0944 3EC3 68                    pla   
0945 3EC4 97 1B                 sta   [<portPtr],y
0946 3EC6              ;
0947 3EC6 20 41 3F              jsr   unlockColor              Leave color table unlocked.
0948 3EC9 18                    clc                            No error flag.
0949 3ECA 60                    rts   
0950 3ECB                       ENDP 
0951 3ECB              ;
0952 3ECB              ;
0953 3ECB              ;===============================================================
0954 3ECB              ;          Operation: testCtl
0955 3ECB              ;===============================================================
0956 3ECB              ;
0957 3ECB              testInfo PROC 
0958 3ECB              ;
0959 3ECB              ;
0960 3ECB A9 13 00              lda   #infoPart                Return info bar part code.
0961 3ECE 85 35                 sta   <result
0962 3ED0 60                    rts   
0963 3ED1                       ENDP 
0964 3ED1              ;
0965 3ED1              ;
0966 3ED1              ;===============================================================
0967 3ED1              ;          Allocate a direct page for the control defProc.
0968 3ED1              ;===============================================================
0969 3ED1              ;
0970 3ED1              startup  PROC 
0971 3ED1              ;
0972 3ED1                                                      ;using equates
0973 3ED1              ;
0974 3ED1              ;
0975 3ED1              ; --- Allocate a stack based direct page -----------------------
0976 3ED1              ;
0977 3ED1 FA                    plx                            Get return address.
0978 3ED2              ;
0979 3ED2 0B                    phd                            Save original direct page.
0980 3ED3              ;
0981 3ED3 3B                    tsc                            Allocate a stack based direct page.
0982 3ED4 38                    sec   
0983 3ED5 E9 25 00              sbc   #saveDpage-1
0984 3ED8 1B                    tcs   
0985 3ED9 5B                    tcd   
0986 3EDA              ;
0987 3EDA DA                    phx                            Put return address back.
0988 3EDB              ;
0989 3EDB 48                    pha   
0990 3EDC 48                    pha   
0991 3EDD A2 0E 58 22           _GetWindowMgrGlobals 
0992 3EE4 68                    pla   
0993 3EE5 85 05                 sta   <globals
0994 3EE7 68                    pla   
0995 3EE8 85 07                 sta   <globals+2
0996 3EEA              ;
0997 3EEA 60                    rts   
0998 3EEB                       ENDP 
0999 3EEB              ;
1000 3EEB              ;
1001 3EEB              ;===============================================================
1002 3EEB              ;          Dereference the control handle.
1003 3EEB              ;===============================================================
1004 3EEB              ;
1005 3EEB              defRefCtl PROC 
1006 3EEB              ;
1007 3EEB                                                      ;using equates
1008 3EEB              ;
1009 3EEB              ;
1010 3EEB A0 02 00              ldy   #2                       Dereference the handle.
1011 3EEE B7 2B                 lda   [<ctlHand],y
1012 3EF0 85 19                 sta   <ctlPtr+2
1013 3EF2 A7 2B                 lda   [<ctlHand]
1014 3EF4 85 17                 sta   <ctlPtr
1015 3EF6 60                    rts   
1016 3EF7                       ENDP 
1017 3EF7              ;
1018 3EF7              ;
1019 3EF7              ;===============================================================
1020 3EF7              ;          Clone control's bounds RECT.
1021 3EF7              ;===============================================================
1022 3EF7              ;
1023 3EF7              ;   IN:    <ctlPtr = pointer to control record.
1024 3EF7              ;
1025 3EF7              ;  OUT:    <cRect = clone of control's ctlRect field.
1026 3EF7              ;
1027 3EF7              *getCtlRect PRIVATE
1028 3EF7              getCtlRect PROC 
1029 3EF7              ;
1030 3EF7                                                      ;using equates
1031 3EF7              ;
1032 3EF7              ;
1033 3EF7 A0 0E 00              ldy   #ctlRect+x2
1034 3EFA A2 06 00              ldx   #x2
1035 3EFD B7 17        lop1     lda   [<ctlPtr],y
1036 3EFF 95 0F                 sta   <cRect,x
1037 3F01 88                    dey   
1038 3F02 88                    dey   
1039 3F03 CA                    dex   
1040 3F04 CA                    dex   
1041 3F05 10 F6                 bpl   lop1
1042 3F07 60                    rts   
1043 3F08                       ENDP 
1044 3F08              ;
1045 3F08              ;
1046 3F08              ;===============================================================
1047 3F08              ;          Set color table pointer.
1048 3F08              ;===============================================================
1049 3F08              ;
1050 3F08              ;   IN:    <ctlWind = pointer to window.
1051 3F08              ;          <globals = pointer to Window Manager globals.
1052 3F08              ;
1053 3F08              ;  OUT:    <colors = pointer to control's color table.
1054 3F08              ;
1055 3F08              getColorTable PROC 
1056 3F08              ;
1057 3F08 A0 E4 00              ldy   #wcolor                  Fetch color table field from window record.
1058 3F0B B7 01                 lda   [<ctlWind],y
1059 3F0D AA                    tax   
1060 3F0E C8                    iny   
1061 3F0F C8                    iny   
1062 3F10 B7 01                 lda   [<ctlWind],y
1063 3F12 30 11                 bmi   @handle                  Is the color table a handle?
1064 3F14 D0 26                 bne   @store1                  Is the color table a pointer?
1065 3F16 9B                    txy   
1066 3F17 D0 23                 bne   @store1
1067 3F19              ;
1068 3F19              ;
1069 3F19              ; --- NIL color table, use default.
1070 3F19              ;
1071 3F19 A0 0A 00              ldy   #defWindClr              Use default color table.
1072 3F1C B7 05                 lda   [<globals],y
1073 3F1E AA                    tax   
1074 3F1F C8                    iny   
1075 3F20 C8                    iny   
1076 3F21 B7 05                 lda   [<globals],y
1077 3F23 10 17                 bpl   @store1                  Is default a pointer?
1078 3F25              ;
1079 3F25              ;
1080 3F25              ; --- Handle for color table.
1081 3F25              ;
1082 3F25 86 09        @handle  stx   <colors                  Store handle.
1083 3F27 85 0B                 sta   <colors+2
1084 3F29              ;
1085 3F29 A0 04 00              ldy   #4                       Lock the color table.
1086 3F2C B7 09                 lda   [<colors],y
1087 3F2E 09 00 80              ora   #$8000
1088 3F31 97 09                 sta   [<colors],y
1089 3F33 88                    dey                            Dereference the color table.
1090 3F34 88                    dey   
1091 3F35 B7 09                 lda   [<colors],y
1092 3F37 48                    pha   
1093 3F38 A7 09                 lda   [<colors]
1094 3F3A AA                    tax   
1095 3F3B 68                    pla   
1096 3F3C              ;
1097 3F3C 86 09        @store1  stx   <colors
1098 3F3E 85 0B                 sta   <colors+2
1099 3F40              ;
1100 3F40 60                    rts   
1101 3F41                       ENDP 
1102 3F41              ;
1103 3F41              ;
1104 3F41              ;
1105 3F41              ;====================================================
1106 3F41              ;          Unlock window's color table.
1107 3F41              ;====================================================
1108 3F41              ;
1109 3F41              ;   IN:    <ctlWind = pointer to window.
1110 3F41              ;
1111 3F41              ;  OUT:    Color table unlocked if it is a handle.  This includes the default table.
1112 3F41              ;
1113 3F41              unlockColor PROC 
1114 3F41              ;
1115 3F41 A0 E4 00              ldy   #wcolor                  Fetch color table field from window record.
1116 3F44 B7 01                 lda   [<ctlWind],y
1117 3F46 AA                    tax   
1118 3F47 C8                    iny   
1119 3F48 C8                    iny   
1120 3F49 B7 01                 lda   [<ctlWind],y
1121 3F4B 30 11                 bmi   @handle                  Is the color table a handle?
1122 3F4D D0 27                 bne   @exit                    Is the color table a pointer?
1123 3F4F 9B                    txy   
1124 3F50 D0 24                 bne   @exit                    If a pointer, nothing to unclock.
1125 3F52              ;
1126 3F52              ;
1127 3F52              ; --- NIL color table, unlock default.
1128 3F52              ;
1129 3F52 A0 0A 00              ldy   #defWindClr              Use default color table.
1130 3F55 B7 05                 lda   [<globals],y
1131 3F57 AA                    tax   
1132 3F58 C8                    iny   
1133 3F59 C8                    iny   
1134 3F5A B7 05                 lda   [<globals],y
1135 3F5C 10 18                 bpl   @exit                    Is default a pointer?  If yes, nothing to unlock.
1136 3F5E              ;
1137 3F5E              ;
1138 3F5E              ; --- Handle for color table.
1139 3F5E              ;
1140 3F5E D4 1D        @handle  pei   <cWork+2                 Save.
1141 3F60 D4 1B                 pei   <cWork
1142 3F62              ;
1143 3F62 85 1B                 sta   <cWork                   Store handle (ROM03 bug)
1144 3F64 86 1D                 stx   <cWork+2
1145 3F66              ;
1146 3F66 A0 04 00              ldy   #4                       Unlock the color table.
1147 3F69 B7 1B                 lda   [<cWork],y
1148 3F6B 29 FF 7F              and   #$7FFF
1149 3F6E 97 1B                 sta   [<cWork],y
1150 3F70              ;
1151 3F70 68                    pla                            Restore.
1152 3F71 85 1B                 sta   <cWork
1153 3F73 68                    pla   
1154 3F74 85 1D                 sta   <cWork+2
1155 3F76              ;
1156 3F76 60           @exit    rts   
1157 3F77                       ENDP 
1158 3F77              ;
1159 3F77              ;
1160 3F77              ;===============================================================
1161 3F77              ;          Fill and frame <cRect.
1162 3F77              ;===============================================================
1163 3F77              ;
1164 3F77              ;   IN:    <cRect = RECT to frame and fill.
1165 3F77              ;          a = bits 4-7 = frame color, others bits are zero.
1166 3F77              ;          y = pattern type in high byte,
1167 3F77              ;              pattern color number in high nybble of low byte,
1168 3F77              ;              background color in low nibble of low byte.
1169 3F77              ;
1170 3F77              *fillFrameRect PRIVATE
1171 3F77              fillFrameRect PROC 
1172 3F77              ;
1173 3F77                                                      ;using equates
1174 3F77              ;
1175 3F77              fillPatt equ   1
1176 3F77              framePatt equ   fillPatt+2
1177 3F77              ;
1178 3F77              ;
1179 3F77 48                    pha                            Save frame pattern.
1180 3F78 5A                    phy                            Save fill pattern.
1181 3F79              ;
1182 3F79 98                    tya                            Fill with solid color?
1183 3F7A 29 00 FF              and   #$FF00
1184 3F7D D0 1A                 bne   enter1                   Can't do special if pattern fill.
1185 3F7F              ;
1186 3F7F              ;
1187 3F7F              ; --- Special case fill and frame in one call ----------------
1188 3F7F              ;
1189 3F7F 20 81 40              jsr   pushRect                 Pass address of 'rect'.
1190 3F82 A3 07                 lda   framePatt+4,s
1191 3F84 20 C7 3F              jsr   pushSmear                Push smeared color.
1192 3F87 A3 07                 lda   fillPatt+6,s
1193 3F89 20 C7 3F              jsr   pushSmear                Push smeared color.
1194 3F8C A2 12 0C 22           _SpecialRect 
1195 3F93 90 2F                 bcc   exit                     Error?
1196 3F95              ;
1197 3F95 68                    pla                            Remove inputs to SpecialRect.
1198 3F96 68                    pla   
1199 3F97 68                    pla   
1200 3F98 68                    pla   
1201 3F99              ;
1202 3F99              ;
1203 3F99              ; --- Draw box with fill pattern -----------------------------
1204 3F99              ;
1205 3F99 A3 03        enter1   lda   framePatt,s
1206 3F9B A8                    tay   
1207 3F9C 20 DB 3F              jsr   set_patt                 Compute pointer to pattern.
1208 3F9F DA                    phx                            Pass address of pattern.
1209 3FA0 5A                    phy   
1210 3FA1 A2 04 30 22           _SetPenPat                     Set color of frame outline.
1211 3FA8              ;
1212 3FA8 20 81 40              jsr   pushRect                 Pass address of 'rect'.
1213 3FAB A3 05                 lda   fillPatt+4,s
1214 3FAD A8                    tay   
1215 3FAE 20 DB 3F              jsr   set_patt
1216 3FB1 DA                    phx                            Pass address of pattern.
1217 3FB2 5A                    phy   
1218 3FB3 A2 04 57 22           _FillRect 
1219 3FBA              ;
1220 3FBA 20 81 40              jsr   pushRect                 Pass address of 'rect'.
1221 3FBD A2 04 53 22           _FrameRect 
1222 3FC4              ;
1223 3FC4 7A           exit     ply                            Take fill pattern off stack.
1224 3FC5 68                    pla                            Take frame pattern off stack.
1225 3FC6 60                    rts   
1226 3FC7              ;
1227 3FC7              ;
1228 3FC7              ; = = = = = = = = = = = = = = = = = = =
1229 3FC7              ;          Push smeared color.
1230 3FC7              ;100= = = = = = = = = = = = = = = = = =
1231 3FC7              ;
1232 3FC7              ;   IN:    a = color in bits 4-7.
1233 3FC7              ;
1234 3FC7              ;  OUT:    Color smeared into all 4 nibbles and pushed on stack.
1235 3FC7              ;
1236 3FC7 FA           pushSmear plx                           Get return address.
1237 3FC8              ;
1238 3FC8 29 F0 00              and   #$00F0
1239 3FCB 48                    pha   
1240 3FCC 4A                    lsr   a
1241 3FCD 4A                    lsr   a
1242 3FCE 4A                    lsr   a
1243 3FCF 4A                    lsr   a
1244 3FD0 03 01                 ora   1,s
1245 3FD2 83 01                 sta   1,s
1246 3FD4 EB                    xba   
1247 3FD5 03 01                 ora   1,s
1248 3FD7 83 01                 sta   1,s
1249 3FD9              ;
1250 3FD9 DA                    phx                            Put return address back.
1251 3FDA 60                    rts   
1252 3FDB                       ENDP 
1253 3FDB              ;
1254 3FDB              ;
1255 3FDB              ;===============================================================
1256 3FDB              ;          Smear a mono bit image into color.
1257 3FDB              ;===============================================================
1258 3FDB              ;
1259 3FDB              ;  IN:     y = pattern type in high byte,
1260 3FDB              ;          pattern color number in high nybble of low byte,
1261 3FDB              ;          background color in low nibble of low byte.
1262 3FDB              ;
1263 3FDB              ; OUT:     x = high word address of pattern.
1264 3FDB              ;          y = low word address of pattern.
1265 3FDB              ;
1266 3FDB              *set_patt   PRIVATE
1267 3FDB              set_patt PROC 
1268 3FDB              ;
1269 3FDB                                                      ;using equates
1270 3FDB              ;
1271 3FDB              ;
1272 3FDB A5 05                 lda   <globals
1273 3FDD A6 07                 ldx   <globals+2
1274 3FDF                       ENDP 
1275 3FDF              ;
1276 3FDF              ;
1277 3FDF              ;   IN:    x/a = pointer to Window Manager's global data area.
1278 3FDF              ;
1279 3FDF                       EXPORT makePattern 
1280 3FDF              makePattern PROC 
1281 3FDF              ;
1282 3FDF                                                      ;using equates
1283 3FDF              ;
1284 3FDF              dataArea equ   1
1285 3FDF              ;
1286 3FDF              ;
1287 3FDF 0B                    phd                            Save caller's direct page pointer.
1288 3FE0              ;
1289 3FE0 DA                    phx                            Save pointer to data area.
1290 3FE1 48                    pha   
1291 3FE2              ;
1292 3FE2 3B                    tsc                            Switch direct page into stack.
1293 3FE3 5B                    tcd   
1294 3FE4              ;
1295 3FE4              ;
1296 3FE4              ; --- Solid color --------------------------------------------
1297 3FE4              ;
1298 3FE4 98                    tya                            Special case, solid pattern.
1299 3FE5 29 00 FF              and   #$FF00
1300 3FE8 D0 10                 bne   buildPatt
1301 3FEA              ;
1302 3FEA 98                    tya   
1303 3FEB 29 F0 00              and   #$00F0
1304 3FEE 0A                    asl   a
1305 3FEF 18                    clc   
1306 3FF0 69 F6 40              adc   #colorBlack
1307 3FF3 A8                    tay   
1308 3FF4 A2 FD 00              ldx   #colorBlack>>16
1309 3FF7 82 64 00              brl   exit
1310 3FFA              ;
1311 3FFA              ;
1312 3FFA              ; --- Fill pattern buffer with pattern color ----------
1313 3FFA              .         
1314 3FFA 98           buildPatt tya                           Get pattern color.
1315 3FFB 4A                    lsr   a
1316 3FFC 4A                    lsr   a
1317 3FFD 4A                    lsr   a
1318 3FFE 4A                    lsr   a
1319 3FFF 20 70 40              jsr   getcolor                 Get color of next to lowest nibble.
1320 4002              ;
1321 4002 48                    pha                            Save color of pattern.
1322 4003 98                    tya   
1323 4004 20 70 40              jsr   getcolor                 Get color of background in low nibble.
1324 4007 48                    pha                            Save color of background.
1325 4008              ;
1326 4008 C0 00 02              cpy   #$0200                   Lined or Dither pattern?
1327 400B B0 1E                 bcs   enter1                   If lined, then ready.
1328 400D              ;
1329 400D              ;
1330 400D              ; --- Special dither pattern -------------------------------------------
1331 400D              ;
1332 400D A8                    tay                            Save background color.
1333 400E 29 F0 F0              and   #$F0F0                   Dither the background color,
1334 4011 83 01                 sta   1,s                      save dither,
1335 4013 A3 03                 lda   3,s                      get foreground color,
1336 4015 29 0F 0F              and   #$0F0F                   dither the foreground color.
1337 4018 03 01                 ora   1,s                      add background color,
1338 401A 83 01                 sta   1,s                      to get background dithered color.
1339 401C              ;
1340 401C A3 03                 lda   3,s                      Get foreground color,
1341 401E 29 F0 F0              and   #$F0F0                   dither it,
1342 4021 83 03                 sta   3,s                      save it.
1343 4023 98                    tya                            Get original background color,
1344 4024 29 0F 0F              and   #$0F0F                   dither it,
1345 4027 03 03                 ora   3,s                      and the foreground dithered color,
1346 4029 83 03                 sta   3,s                      to get foreground dithered color.
1347 402B              ;
1348 402B              ;
1349 402B              ;  On stack:     3 foreground color.
1350 402B              ;                1 background color.
1351 402B              ;
1352 402B              ;
1353 402B A2 22 00     enter1   ldx   #pattern+14              16 bytes if 640 mode.
1354 402E A0 12 00              ldy   #screenMode
1355 4031 B7 01                 lda   [<dataArea],y            Get current mode.
1356 4033 D0 03                 bne   ok1                      Which mode are we in?
1357 4035 A2 32 00              ldx   #pattern+30              32 bytes if 320 mode.
1358 4038 9B           ok1      txy                            y = index into pattern buffer.
1359 4039 AA                    tax                            x = mode, FALSE if 320, TRUE if 640.
1360 403A              ;
1361 403A 20 62 40     lop3     jsr   setFore                  Store a WORD of foreground color.
1362 403D 8A                    txa                            Which mode?
1363 403E D0 03                 bne   skip1
1364 4040 20 62 40              jsr   setFore                  If 320 store 2 words of foreground.
1365 4043              ;
1366 4043 20 66 40     skip1    jsr   setBack                  Store a WORD of background color.
1367 4046 90 08                 bcc   done                     Buffer full?
1368 4048 8A                    txa                            Which mode?
1369 4049 D0 EF                 bne   lop3
1370 404B 20 66 40              jsr   setBack                  If 320 store 2 words of background.
1371 404E B0 EA                 bcs   lop3                     Buffer full?
1372 4050              ;
1373 4050              ;
1374 4050 68           done     pla                            Get rid of fore and background colors.
1375 4051 68                    pla   
1376 4052              ;
1377 4052              ;
1378 4052 A6 03                 ldx   <dataArea+2              Return address of pattern buffer.
1379 4054 A5 01                 lda   <dataArea
1380 4056 18                    clc   
1381 4057 69 14 00              adc   #pattern
1382 405A 90 01                 bcc   ok2
1383 405C E8                    inx   
1384 405D A8           ok2      tay   
1385 405E              ;
1386 405E 68           exit     pla                            Get rid of stack direct page.
1387 405F 68                    pla   
1388 4060              ;
1389 4060 2B                    pld                            Return caller's direct page.
1390 4061 60                    rts   
1391 4062              ;
1392 4062              ;
1393 4062              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1394 4062
1395 4062              ;          Put word of foreground color into pattern buffer.
1396 4062              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1397 4062              ;
1398 4062              ;   IN:    y = index into pattern buffer to store foreground color.
1399 4062              ;
1400 4062              ;  OUT:    Carry clear if pattern is now full.
1401 4062              ;
1402 4062 A3 05        setFore  lda   5,s                      Get foreground color.
1403 4064 80 02                 bra   enter110
1404 4066              ;
1405 4066              ;
1406 4066              ;
1407 4066              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1408 4066
1409 4066              ;          Put word of background color into pattern buffer.
1410 4066              ;110= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1411 4066              ;
1412 4066              ;   IN:    y = index into pattern buffer to store background color.
1413 4066              ;
1414 4066              ;  OUT:    Carry clear if pattern is now full.
1415 4066              ;
1416 4066 A3 03        setBack  lda   3,s                      Get background color.
1417 4068              ;
1418 4068 97 01        enter110 sta   [<dataArea],y
1419 406A 88                    dey   
1420 406B 88                    dey   
1421 406C C0 14 00              cpy   #pattern
1422 406F 60                    rts   
1423 4070              ;
1424 4070              ;
1425 4070              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1426 4070
1427 4070              ;          Smear low nibble into all nibbles.
1428 4070              ;120= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1429 4070              ;
1430 4070              ;   IN:    a = color in low nibble.
1431 4070              ;
1432 4070              ;  OUT:    a = color in all four nibbles.
1433 4070              ;
1434 4070 29 0F 00     getcolor and   #$000F
1435 4073 48                    pha   
1436 4074 0A                    asl   a
1437 4075 0A                    asl   a
1438 4076 0A                    asl   a
1439 4077 0A                    asl   a
1440 4078 03 01                 ora   1,s
1441 407A 83 01                 sta   1,s
1442 407C EB                    xba   
1443 407D 03 01                 ora   1,s
1444 407F FA                    plx   
1445 4080 60                    rts   
1446 4081              ;
1447 4081                       ENDP 
1448 4081              ;
1449 4081              ;
1450 4081              ;===============================================================
1451 4081              ;          Push pointer to direct page location.
1452 4081              ;===============================================================
1453 4081              ;
1454 4081              *pushRect   PRIVATE
1455 4081              pushRect PROC 
1456 4081              ;
1457 4081                                                      ;using equates
1458 4081              ;
1459 4081              ;
1460 4081 A9 0F 00              lda   #cRect
1461 4084 82 DD 4E              brl   pushDpage
1462 4087                       ENDP 
1463 4087              ;
1464 4087              ;
1465 4087              ;===============================================================
1466 4087              ;          Push long value from control record.
1467 4087              ;===============================================================
1468 4087              ;
1469 4087              ;   IN:    <ctlPtr = pointer to control record.
1470 4087              ;          y = index to high word of field to push.
1471 4087              ;
1472 4087              *pushCtlLong PRIVATE
1473 4087              pushCtlLong PROC 
1474 4087              ;
1475 4087                                                      ;using equates
1476 4087              ;
1477 4087              ;
1478 4087 FA                    plx                            Get return address.
1479 4088              ;
1480 4088 B7 17                 lda   [<ctlPtr],y
1481 408A 48                    pha   
1482 408B 88                    dey   
1483 408C 88                    dey   
1484 408D B7 17                 lda   [<ctlPtr],y
1485 408F 48                    pha   
1486 4090              ;
1487 4090 DA                    phx                            Put return address back.
1488 4091 60                    rts   
1489 4092                       ENDP 
1490 4092              ;
1491 4092              ;
1492 4092              ;===============================================================
1493 4092              ;          Get zoom box's coordinates.
1494 4092              ;===============================================================
1495 4092              ;
1496 4092              ;   IN:    <ctlPtr = pointer to title bar control.
1497 4092              ;
1498 4092              ;  OUT:    <cRect = zoom box's coordinates.
1499 4092              ;
1500 4092              *getzoomcor  PRIVATE
1501 4092              getzoomcor PROC 
1502 4092              ;
1503 4092                                                      ;using equates
1504 4092              ;
1505 4092              ;
1506 4092 A0 0E 00              ldy   #ctlRect+x2
1507 4095 B7 17                 lda   [<ctlPtr],y
1508 4097 38                    sec   
1509 4098 E9 0A 00              sbc   #CLOSEL
1510 409B 85 15                 sta   <cRect+x2
1511 409D 38                    sec   
1512 409E A0 08 00              ldy   #closeWidth
1513 40A1 F7 05                 sbc   [<globals],y             Less width of icon font.
1514 40A3 85 11                 sta   <cRect+x1
1515 40A5              ;
1516 40A5 80 0D                 bra   top_bottom               Compute top and bottom.
1517 40A7              ;
1518 40A7              ;
1519 40A7              ;
1520 40A7              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1521 40A7
1522 40A7              ;          Get close box's coordinates.
1523 40A7              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1524 40A7              ;
1525 40A7              ;   IN:    <globals = pointer to Window Manager globals.
1526 40A7              ;
1527 40A7              ;  OUT:    <cRect = close box's coordinates.
1528 40A7              ;
1529 40A7                       ENTRY getCloseCor 
1530 40A7              getCloseCor                             ;       
1531 40A7              ;
1532 40A7 A9 0A 00              lda   #CLOSEL
1533 40AA 85 11                 sta   <cRect+x1
1534 40AC 18                    clc   
1535 40AD A0 08 00              ldy   #closeWidth
1536 40B0 77 05                 adc   [<globals],y             Add width of icon font.
1537 40B2 85 15                 sta   <cRect+x2
1538 40B4              ;
1539 40B4 A9 02 00     top_bottom lda   #CLOSET
1540 40B7 85 0F                 sta   <cRect+y1
1541 40B9 18                    clc   
1542 40BA A0 06 00              ldy   #closeHeight
1543 40BD 77 05                 adc   [<globals],y             Add height of icon font.
1544 40BF 85 13                 sta   <cRect+y2
1545 40C1 60                    rts   
1546 40C2              ;
1547 40C2                       ENTRY getCoords 
1548 40C2              getCoords                               ;       
1549 40C2 A7 40 92 40           DC W:getCloseCor,getzoomcor
1550 40C6              ;
1551 40C6                       ENDP 
1552 40C6              ;
1553 40C6              ;
1554 40C6              ;==================================================
1555 40C6              ;          Smear color into all 4 nibbles.
1556 40C6              ;==================================================
1557 40C6              ;
1558 40C6              ;   IN:    a = color in low nibble.
1559 40C6              ;
1560 40C6              ;  OUT:    a = color in all 4 nibbles.
1561 40C6              ;
1562 40C6              *smear      PRIVATE
1563 40C6              smear    PROC 
1564 40C6              ;
1565 40C6 29 0F 00              and   #$000F
1566 40C9 48                    pha   
1567 40CA 0A                    asl   a
1568 40CB 0A                    asl   a
1569 40CC 0A                    asl   a
1570 40CD 0A                    asl   a
1571 40CE 03 01                 ora   1,s
1572 40D0 83 01                 sta   1,s
1573 40D2 EB                    xba   
1574 40D3 03 01                 ora   1,s
1575 40D5 FA                    plx   
1576 40D6 60                    rts   
1577 40D7                       ENDP 
1578 40D7              ;
1579 40D7              ;
1580 40D7              ;================================
1581 40D7              ;          Push line size.
1582 40D7              ;================================
1583 40D7              ;
1584 40D7              ;   IN:    <globals = pointer to Window Manager's global data area.
1585 40D7              ;
1586 40D7              ;  OUT:    PUSH:WORD - width of lines.
1587 40D7              ;          PUSH:WORD - height of lines.
1588 40D7              ;
1589 40D7              *pushLineSize PRIVATE
1590 40D7              pushLineSize PROC 
1591 40D7              ;
1592 40D7                                                      ;using equates
1593 40D7              ;
1594 40D7              ;
1595 40D7 20 DF 40              jsr   getLineSize              a = width, x = height.
1596 40DA              ;
1597 40DA 7A                    ply                            Get return address.
1598 40DB              ;
1599 40DB 48                    pha                            Push width.
1600 40DC DA                    phx                            Push height.
1601 40DD              ;
1602 40DD 5A                    phy                            Put return address back.
1603 40DE 60                    rts   
1604 40DF                       ENDP 
1605 40DF              ;
1606 40DF              ;
1607 40DF              ;===================================
1608 40DF              ;          Get size of lines.
1609 40DF              ;===================================
1610 40DF              ;
1611 40DF              ;   IN:    <globals = pointer to Window Manager's global data area.
1612 40DF              ;
1613 40DF              ;  OUT:    a = width of lines.
1614 40DF              ;          x = height of lines.
1615 40DF              ;
1616 40DF              *getLineSize PRIVATE
1617 40DF              getLineSize PROC 
1618 40DF              ;
1619 40DF                                                      ;using equates
1620 40DF              ;
1621 40DF              ;
1622 40DF A0 00 00              ldy   #lineW
1623 40E2 B7 05                 lda   [<globals],y             Return width in a.
1624 40E4 A2 01 00              ldx   #1                       Return height in x.
1625 40E7 60                    rts   
1626 40E8                       ENDP 
1627 40E8              ;
1628 40E8              ;
1629 40E8              ;=======================================================
1630 40E8              ;          Get pointer to window controls control.
1631 40E8              ;=======================================================
1632 40E8              ;
1633 40E8              ;   IN:    <ctlPtr = pointer to control.
1634 40E8              ;          ctlData = pointer to window.
1635 40E8              ;
1636 40E8              ;  OUT:    <ctlWind = pointer to window that controls are around.
1637 40E8              ;
1638 40E8              *getWindPtr PRIVATE
1639 40E8              getWindPtr PROC 
1640 40E8              ;
1641 40E8                                                      ;using equates
1642 40E8              ;
1643 40E8              ;
1644 40E8 A0 1C 00              ldy   #ctlData
1645 40EB B7 17                 lda   [<ctlPtr],y
1646 40ED 85 01                 sta   <ctlWind
1647 40EF C8                    iny   
1648 40F0 C8                    iny   
1649 40F1 B7 17                 lda   [<ctlPtr],y
1650 40F3 85 03                 sta   <ctlWind+2
1651 40F5 60                    rts   
1652 40F6                       ENDP 
1653 40F6              ;
1654 40F6              ;========================================
1655 40F6              ;          Solid color patterns.
1656 40F6              ;========================================
1657 40F6              ;
1658 40F6                       EXPORT solidColors 
1659 40F6              solidColors PROC 
1660 40F6
1661 40F6                       EXPORT colorBlack 
1662 40F6              colorBlack      
1663 40F6 00                    DC B:$00
1664 40F7 00                    DC B:$00
1665 40F8 00                    DC B:$00
1666 40F9 00                    DC B:$00
1667 40FA 00                    DC B:$00
1668 40FB 00                    DC B:$00
1669 40FC 00                    DC B:$00
1670 40FD 00                    DC B:$00
1671 40FE 00                    DC B:$00
1672 40FF 00                    DC B:$00
1673 4100 00                    DC B:$00
1674 4101 00                    DC B:$00
1675 4102 00                    DC B:$00
1676 4103 00                    DC B:$00
1677 4104 00                    DC B:$00
1678 4105 00                    DC B:$00
1679 4106 00                    DC B:$00
1680 4107 00                    DC B:$00
1681 4108 00                    DC B:$00
1682 4109 00                    DC B:$00
1683 410A 00                    DC B:$00
1684 410B 00                    DC B:$00
1685 410C 00                    DC B:$00
1686 410D 00                    DC B:$00
1687 410E 00                    DC B:$00
1688 410F 00                    DC B:$00
1689 4110 00                    DC B:$00
1690 4111 00                    DC B:$00
1691 4112 00                    DC B:$00
1692 4113 00                    DC B:$00
1693 4114 00                    DC B:$00
1694 4115 00                    DC B:$00
1695 4116 11                    DC B:$11
1696 4117 11                    DC B:$11
1697 4118 11                    DC B:$11
1698 4119 11                    DC B:$11
1699 411A 11                    DC B:$11
1700 411B 11                    DC B:$11
1701 411C 11                    DC B:$11
1702 411D 11                    DC B:$11
1703 411E 11                    DC B:$11
1704 411F 11                    DC B:$11
1705 4120 11                    DC B:$11
1706 4121 11                    DC B:$11
1707 4122 11                    DC B:$11
1708 4123 11                    DC B:$11
1709 4124 11                    DC B:$11
1710 4125 11                    DC B:$11
1711 4126 11                    DC B:$11
1712 4127 11                    DC B:$11
1713 4128 11                    DC B:$11
1714 4129 11                    DC B:$11
1715 412A 11                    DC B:$11
1716 412B 11                    DC B:$11
1717 412C 11                    DC B:$11
1718 412D 11                    DC B:$11
1719 412E 11                    DC B:$11
1720 412F 11                    DC B:$11
1721 4130 11                    DC B:$11
1722 4131 11                    DC B:$11
1723 4132 11                    DC B:$11
1724 4133 11                    DC B:$11
1725 4134 11                    DC B:$11
1726 4135 11                    DC B:$11
1727 4136 22                    DC B:$22
1728 4137 22                    DC B:$22
1729 4138 22                    DC B:$22
1730 4139 22                    DC B:$22
1731 413A 22                    DC B:$22
1732 413B 22                    DC B:$22
1733 413C 22                    DC B:$22
1734 413D 22                    DC B:$22
1735 413E 22                    DC B:$22
1736 413F 22                    DC B:$22
1737 4140 22                    DC B:$22
1738 4141 22                    DC B:$22
1739 4142 22                    DC B:$22
1740 4143 22                    DC B:$22
1741 4144 22                    DC B:$22
1742 4145 22                    DC B:$22
1743 4146 22                    DC B:$22
1744 4147 22                    DC B:$22
1745 4148 22                    DC B:$22
1746 4149 22                    DC B:$22
1747 414A 22                    DC B:$22
1748 414B 22                    DC B:$22
1749 414C 22                    DC B:$22
1750 414D 22                    DC B:$22
1751 414E 22                    DC B:$22
1752 414F 22                    DC B:$22
1753 4150 22                    DC B:$22
1754 4151 22                    DC B:$22
1755 4152 22                    DC B:$22
1756 4153 22                    DC B:$22
1757 4154 22                    DC B:$22
1758 4155 22                    DC B:$22
1759 4156 33                    DC B:$33
1760 4157 33                    DC B:$33
1761 4158 33                    DC B:$33
1762 4159 33                    DC B:$33
1763 415A 33                    DC B:$33
1764 415B 33                    DC B:$33
1765 415C 33                    DC B:$33
1766 415D 33                    DC B:$33
1767 415E 33                    DC B:$33
1768 415F 33                    DC B:$33
1769 4160 33                    DC B:$33
1770 4161 33                    DC B:$33
1771 4162 33                    DC B:$33
1772 4163 33                    DC B:$33
1773 4164 33                    DC B:$33
1774 4165 33                    DC B:$33
1775 4166 33                    DC B:$33
1776 4167 33                    DC B:$33
1777 4168 33                    DC B:$33
1778 4169 33                    DC B:$33
1779 416A 33                    DC B:$33
1780 416B 33                    DC B:$33
1781 416C 33                    DC B:$33
1782 416D 33                    DC B:$33
1783 416E 33                    DC B:$33
1784 416F 33                    DC B:$33
1785 4170 33                    DC B:$33
1786 4171 33                    DC B:$33
1787 4172 33                    DC B:$33
1788 4173 33                    DC B:$33
1789 4174 33                    DC B:$33
1790 4175 33                    DC B:$33
1791 4176 44                    DC B:$44
1792 4177 44                    DC B:$44
1793 4178 44                    DC B:$44
1794 4179 44                    DC B:$44
1795 417A 44                    DC B:$44
1796 417B 44                    DC B:$44
1797 417C 44                    DC B:$44
1798 417D 44                    DC B:$44
1799 417E 44                    DC B:$44
1800 417F 44                    DC B:$44
1801 4180 44                    DC B:$44
1802 4181 44                    DC B:$44
1803 4182 44                    DC B:$44
1804 4183 44                    DC B:$44
1805 4184 44                    DC B:$44
1806 4185 44                    DC B:$44
1807 4186 44                    DC B:$44
1808 4187 44                    DC B:$44
1809 4188 44                    DC B:$44
1810 4189 44                    DC B:$44
1811 418A 44                    DC B:$44
1812 418B 44                    DC B:$44
1813 418C 44                    DC B:$44
1814 418D 44                    DC B:$44
1815 418E 44                    DC B:$44
1816 418F 44                    DC B:$44
1817 4190 44                    DC B:$44
1818 4191 44                    DC B:$44
1819 4192 44                    DC B:$44
1820 4193 44                    DC B:$44
1821 4194 44                    DC B:$44
1822 4195 44                    DC B:$44
1823 4196 55                    DC B:$55
1824 4197 55                    DC B:$55
1825 4198 55                    DC B:$55
1826 4199 55                    DC B:$55
1827 419A 55                    DC B:$55
1828 419B 55                    DC B:$55
1829 419C 55                    DC B:$55
1830 419D 55                    DC B:$55
1831 419E 55                    DC B:$55
1832 419F 55                    DC B:$55
1833 41A0 55                    DC B:$55
1834 41A1 55                    DC B:$55
1835 41A2 55                    DC B:$55
1836 41A3 55                    DC B:$55
1837 41A4 55                    DC B:$55
1838 41A5 55                    DC B:$55
1839 41A6 55                    DC B:$55
1840 41A7 55                    DC B:$55
1841 41A8 55                    DC B:$55
1842 41A9 55                    DC B:$55
1843 41AA 55                    DC B:$55
1844 41AB 55                    DC B:$55
1845 41AC 55                    DC B:$55
1846 41AD 55                    DC B:$55
1847 41AE 55                    DC B:$55
1848 41AF 55                    DC B:$55
1849 41B0 55                    DC B:$55
1850 41B1 55                    DC B:$55
1851 41B2 55                    DC B:$55
1852 41B3 55                    DC B:$55
1853 41B4 55                    DC B:$55
1854 41B5 55                    DC B:$55
1855 41B6 66                    DC B:$66
1856 41B7 66                    DC B:$66
1857 41B8 66                    DC B:$66
1858 41B9 66                    DC B:$66
1859 41BA 66                    DC B:$66
1860 41BB 66                    DC B:$66
1861 41BC 66                    DC B:$66
1862 41BD 66                    DC B:$66
1863 41BE 66                    DC B:$66
1864 41BF 66                    DC B:$66
1865 41C0 66                    DC B:$66
1866 41C1 66                    DC B:$66
1867 41C2 66                    DC B:$66
1868 41C3 66                    DC B:$66
1869 41C4 66                    DC B:$66
1870 41C5 66                    DC B:$66
1871 41C6 66                    DC B:$66
1872 41C7 66                    DC B:$66
1873 41C8 66                    DC B:$66
1874 41C9 66                    DC B:$66
1875 41CA 66                    DC B:$66
1876 41CB 66                    DC B:$66
1877 41CC 66                    DC B:$66
1878 41CD 66                    DC B:$66
1879 41CE 66                    DC B:$66
1880 41CF 66                    DC B:$66
1881 41D0 66                    DC B:$66
1882 41D1 66                    DC B:$66
1883 41D2 66                    DC B:$66
1884 41D3 66                    DC B:$66
1885 41D4 66                    DC B:$66
1886 41D5 66                    DC B:$66
1887 41D6 77                    DC B:$77
1888 41D7 77                    DC B:$77
1889 41D8 77                    DC B:$77
1890 41D9 77                    DC B:$77
1891 41DA 77                    DC B:$77
1892 41DB 77                    DC B:$77
1893 41DC 77                    DC B:$77
1894 41DD 77                    DC B:$77
1895 41DE 77                    DC B:$77
1896 41DF 77                    DC B:$77
1897 41E0 77                    DC B:$77
1898 41E1 77                    DC B:$77
1899 41E2 77                    DC B:$77
1900 41E3 77                    DC B:$77
1901 41E4 77                    DC B:$77
1902 41E5 77                    DC B:$77
1903 41E6 77                    DC B:$77
1904 41E7 77                    DC B:$77
1905 41E8 77                    DC B:$77
1906 41E9 77                    DC B:$77
1907 41EA 77                    DC B:$77
1908 41EB 77                    DC B:$77
1909 41EC 77                    DC B:$77
1910 41ED 77                    DC B:$77
1911 41EE 77                    DC B:$77
1912 41EF 77                    DC B:$77
1913 41F0 77                    DC B:$77
1914 41F1 77                    DC B:$77
1915 41F2 77                    DC B:$77
1916 41F3 77                    DC B:$77
1917 41F4 77                    DC B:$77
1918 41F5 77                    DC B:$77
1919 41F6 88                    DC B:$88
1920 41F7 88                    DC B:$88
1921 41F8 88                    DC B:$88
1922 41F9 88                    DC B:$88
1923 41FA 88                    DC B:$88
1924 41FB 88                    DC B:$88
1925 41FC 88                    DC B:$88
1926 41FD 88                    DC B:$88
1927 41FE 88                    DC B:$88
1928 41FF 88                    DC B:$88
1929 4200 88                    DC B:$88
1930 4201 88                    DC B:$88
1931 4202 88                    DC B:$88
1932 4203 88                    DC B:$88
1933 4204 88                    DC B:$88
1934 4205 88                    DC B:$88
1935 4206 88                    DC B:$88
1936 4207 88                    DC B:$88
1937 4208 88                    DC B:$88
1938 4209 88                    DC B:$88
1939 420A 88                    DC B:$88
1940 420B 88                    DC B:$88
1941 420C 88                    DC B:$88
1942 420D 88                    DC B:$88
1943 420E 88                    DC B:$88
1944 420F 88                    DC B:$88
1945 4210 88                    DC B:$88
1946 4211 88                    DC B:$88
1947 4212 88                    DC B:$88
1948 4213 88                    DC B:$88
1949 4214 88                    DC B:$88
1950 4215 88                    DC B:$88
1951 4216 99                    DC B:$99
1952 4217 99                    DC B:$99
1953 4218 99                    DC B:$99
1954 4219 99                    DC B:$99
1955 421A 99                    DC B:$99
1956 421B 99                    DC B:$99
1957 421C 99                    DC B:$99
1958 421D 99                    DC B:$99
1959 421E 99                    DC B:$99
1960 421F 99                    DC B:$99
1961 4220 99                    DC B:$99
1962 4221 99                    DC B:$99
1963 4222 99                    DC B:$99
1964 4223 99                    DC B:$99
1965 4224 99                    DC B:$99
1966 4225 99                    DC B:$99
1967 4226 99                    DC B:$99
1968 4227 99                    DC B:$99
1969 4228 99                    DC B:$99
1970 4229 99                    DC B:$99
1971 422A 99                    DC B:$99
1972 422B 99                    DC B:$99
1973 422C 99                    DC B:$99
1974 422D 99                    DC B:$99
1975 422E 99                    DC B:$99
1976 422F 99                    DC B:$99
1977 4230 99                    DC B:$99
1978 4231 99                    DC B:$99
1979 4232 99                    DC B:$99
1980 4233 99                    DC B:$99
1981 4234 99                    DC B:$99
1982 4235 99                    DC B:$99
1983 4236 AA                    DC B:$AA
1984 4237 AA                    DC B:$AA
1985 4238 AA                    DC B:$AA
1986 4239 AA                    DC B:$AA
1987 423A AA                    DC B:$AA
1988 423B AA                    DC B:$AA
1989 423C AA                    DC B:$AA
1990 423D AA                    DC B:$AA
1991 423E AA                    DC B:$AA
1992 423F AA                    DC B:$AA
1993 4240 AA                    DC B:$AA
1994 4241 AA                    DC B:$AA
1995 4242 AA                    DC B:$AA
1996 4243 AA                    DC B:$AA
1997 4244 AA                    DC B:$AA
1998 4245 AA                    DC B:$AA
1999 4246 AA                    DC B:$AA
2000 4247 AA                    DC B:$AA
2001 4248 AA                    DC B:$AA
2002 4249 AA                    DC B:$AA
2003 424A AA                    DC B:$AA
2004 424B AA                    DC B:$AA
2005 424C AA                    DC B:$AA
2006 424D AA                    DC B:$AA
2007 424E AA                    DC B:$AA
2008 424F AA                    DC B:$AA
2009 4250 AA                    DC B:$AA
2010 4251 AA                    DC B:$AA
2011 4252 AA                    DC B:$AA
2012 4253 AA                    DC B:$AA
2013 4254 AA                    DC B:$AA
2014 4255 AA                    DC B:$AA
2015 4256 BB                    DC B:$BB
2016 4257 BB                    DC B:$BB
2017 4258 BB                    DC B:$BB
2018 4259 BB                    DC B:$BB
2019 425A BB                    DC B:$BB
2020 425B BB                    DC B:$BB
2021 425C BB                    DC B:$BB
2022 425D BB                    DC B:$BB
2023 425E BB                    DC B:$BB
2024 425F BB                    DC B:$BB
2025 4260 BB                    DC B:$BB
2026 4261 BB                    DC B:$BB
2027 4262 BB                    DC B:$BB
2028 4263 BB                    DC B:$BB
2029 4264 BB                    DC B:$BB
2030 4265 BB                    DC B:$BB
2031 4266 BB                    DC B:$BB
2032 4267 BB                    DC B:$BB
2033 4268 BB                    DC B:$BB
2034 4269 BB                    DC B:$BB
2035 426A BB                    DC B:$BB
2036 426B BB                    DC B:$BB
2037 426C BB                    DC B:$BB
2038 426D BB                    DC B:$BB
2039 426E BB                    DC B:$BB
2040 426F BB                    DC B:$BB
2041 4270 BB                    DC B:$BB
2042 4271 BB                    DC B:$BB
2043 4272 BB                    DC B:$BB
2044 4273 BB                    DC B:$BB
2045 4274 BB                    DC B:$BB
2046 4275 BB                    DC B:$BB
2047 4276 CC                    DC B:$CC
2048 4277 CC                    DC B:$CC
2049 4278 CC                    DC B:$CC
2050 4279 CC                    DC B:$CC
2051 427A CC                    DC B:$CC
2052 427B CC                    DC B:$CC
2053 427C CC                    DC B:$CC
2054 427D CC                    DC B:$CC
2055 427E CC                    DC B:$CC
2056 427F CC                    DC B:$CC
2057 4280 CC                    DC B:$CC
2058 4281 CC                    DC B:$CC
2059 4282 CC                    DC B:$CC
2060 4283 CC                    DC B:$CC
2061 4284 CC                    DC B:$CC
2062 4285 CC                    DC B:$CC
2063 4286 CC                    DC B:$CC
2064 4287 CC                    DC B:$CC
2065 4288 CC                    DC B:$CC
2066 4289 CC                    DC B:$CC
2067 428A CC                    DC B:$CC
2068 428B CC                    DC B:$CC
2069 428C CC                    DC B:$CC
2070 428D CC                    DC B:$CC
2071 428E CC                    DC B:$CC
2072 428F CC                    DC B:$CC
2073 4290 CC                    DC B:$CC
2074 4291 CC                    DC B:$CC
2075 4292 CC                    DC B:$CC
2076 4293 CC                    DC B:$CC
2077 4294 CC                    DC B:$CC
2078 4295 CC                    DC B:$CC
2079 4296 DD                    DC B:$DD
2080 4297 DD                    DC B:$DD
2081 4298 DD                    DC B:$DD
2082 4299 DD                    DC B:$DD
2083 429A DD                    DC B:$DD
2084 429B DD                    DC B:$DD
2085 429C DD                    DC B:$DD
2086 429D DD                    DC B:$DD
2087 429E DD                    DC B:$DD
2088 429F DD                    DC B:$DD
2089 42A0 DD                    DC B:$DD
2090 42A1 DD                    DC B:$DD
2091 42A2 DD                    DC B:$DD
2092 42A3 DD                    DC B:$DD
2093 42A4 DD                    DC B:$DD
2094 42A5 DD                    DC B:$DD
2095 42A6 DD                    DC B:$DD
2096 42A7 DD                    DC B:$DD
2097 42A8 DD                    DC B:$DD
2098 42A9 DD                    DC B:$DD
2099 42AA DD                    DC B:$DD
2100 42AB DD                    DC B:$DD
2101 42AC DD                    DC B:$DD
2102 42AD DD                    DC B:$DD
2103 42AE DD                    DC B:$DD
2104 42AF DD                    DC B:$DD
2105 42B0 DD                    DC B:$DD
2106 42B1 DD                    DC B:$DD
2107 42B2 DD                    DC B:$DD
2108 42B3 DD                    DC B:$DD
2109 42B4 DD                    DC B:$DD
2110 42B5 DD                    DC B:$DD
2111 42B6 EE                    DC B:$EE
2112 42B7 EE                    DC B:$EE
2113 42B8 EE                    DC B:$EE
2114 42B9 EE                    DC B:$EE
2115 42BA EE                    DC B:$EE
2116 42BB EE                    DC B:$EE
2117 42BC EE                    DC B:$EE
2118 42BD EE                    DC B:$EE
2119 42BE EE                    DC B:$EE
2120 42BF EE                    DC B:$EE
2121 42C0 EE                    DC B:$EE
2122 42C1 EE                    DC B:$EE
2123 42C2 EE                    DC B:$EE
2124 42C3 EE                    DC B:$EE
2125 42C4 EE                    DC B:$EE
2126 42C5 EE                    DC B:$EE
2127 42C6 EE                    DC B:$EE
2128 42C7 EE                    DC B:$EE
2129 42C8 EE                    DC B:$EE
2130 42C9 EE                    DC B:$EE
2131 42CA EE                    DC B:$EE
2132 42CB EE                    DC B:$EE
2133 42CC EE                    DC B:$EE
2134 42CD EE                    DC B:$EE
2135 42CE EE                    DC B:$EE
2136 42CF EE                    DC B:$EE
2137 42D0 EE                    DC B:$EE
2138 42D1 EE                    DC B:$EE
2139 42D2 EE                    DC B:$EE
2140 42D3 EE                    DC B:$EE
2141 42D4 EE                    DC B:$EE
2142 42D5 EE                    DC B:$EE
2143 42D6                       EXPORT colorWhite 
2144 42D6              colorWhite  
2145 42D6 FF                    DC B:$FF
2146 42D7 FF                    DC B:$FF
2147 42D8 FF                    DC B:$FF
2148 42D9 FF                    DC B:$FF
2149 42DA FF                    DC B:$FF
2150 42DB FF                    DC B:$FF
2151 42DC FF                    DC B:$FF
2152 42DD FF                    DC B:$FF
2153 42DE FF                    DC B:$FF
2154 42DF FF                    DC B:$FF
2155 42E0 FF                    DC B:$FF
2156 42E1 FF                    DC B:$FF
2157 42E2 FF                    DC B:$FF
2158 42E3 FF                    DC B:$FF
2159 42E4 FF                    DC B:$FF
2160 42E5 FF                    DC B:$FF
2161 42E6 FF                    DC B:$FF
2162 42E7 FF                    DC B:$FF
2163 42E8 FF                    DC B:$FF
2164 42E9 FF                    DC B:$FF
2165 42EA FF                    DC B:$FF
2166 42EB FF                    DC B:$FF
2167 42EC FF                    DC B:$FF
2168 42ED FF                    DC B:$FF
2169 42EE FF                    DC B:$FF
2170 42EF FF                    DC B:$FF
2171 42F0 FF                    DC B:$FF
2172 42F1 FF                    DC B:$FF
2173 42F2 FF                    DC B:$FF
2174 42F3 FF                    DC B:$FF
2175 42F4 FF                    DC B:$FF
2176 42F5 FF                    DC B:$FF
2177 42F6
2178 42F6                       ENDP 
2179 42F6
2180 42F6              ;=====================================================================
2181 42F6              ;                   Push pointer to window's title.
2182 42F6              ;=====================================================================
2183 42F6              ;
2184 42F6              ;   IN: <ctlWind = pointer to window.
2185 42F6              ;
2186 42F6              ;  OUT: Window title pointer on stack, handle locked.
2187 42F6              ;       Call unlockTitle when done.
2188 42F6              ;
2189 42F6              pushWindTitle PROC 
2190 42F6              ;
2191 42F6 A0 D6 00              ldy   #wTitle+2                Is title a handle?
2192 42F9 B7 01                 lda   [<ctlWind],y
2193 42FB 30 09                 bmi   @handle
2194 42FD FA           @justPush plx                           Get return address.
2195 42FE 48                    pha   
2196 42FF 88                    dey   
2197 4300 88                    dey   
2198 4301 B7 01                 lda   [<ctlWind],y
2199 4303 48                    pha   
2200 4304 DA                    phx   
2201 4305 60                    rts   
2202 4306              ;
2203 4306              ;
2204 4306              ; --- Title is a handle.
2205 4306              ;
2206 4306 D4 1D        @handle  pei   <cWork+2                 Save.
2207 4308 D4 1B                 pei   <cWork
2208 430A              ;
2209 430A 85 1D                 sta   <cWork+2
2210 430C 88                    dey   
2211 430D 88                    dey   
2212 430E B7 01                 lda   [<ctlWind],y
2213 4310 85 1B                 sta   <cWork
2214 4312              ;
2215 4312 A0 04 00              ldy   #4                       Lock the title.
2216 4315 B7 1B                 lda   [<cWork],y
2217 4317 09 00 80              ora   #$8000
2218 431A 97 1B                 sta   [<cWork],y
2219 431C 88                    dey                            Get title pointer.
2220 431D 88                    dey   
2221 431E B7 1B                 lda   [<cWork],y
2222 4320 A8                    tay   
2223 4321 A7 1B                 lda   [<cWork]
2224 4323              ;
2225 4323 FA                    plx                            Restore.
2226 4324 86 1B                 stx   <cWork
2227 4326 FA                    plx   
2228 4327 86 1D                 stx   <cWork+2
2229 4329              ;
2230 4329 FA                    plx                            Get return address.
2231 432A 5A                    phy                            Push title pointer on stack.
2232 432B 48                    pha   
2233 432C DA                    phx                            Put return address back.
2234 432D 60                    rts   
2235 432E              ;
2236 432E                       ENDP 
2237 432E              ;
2238 432E              ;
2239 432E              ;================================================================
2240 432E              ;                   Unlock window title handle.
2241 432E              ;================================================================
2242 432E              ;
2243 432E              ;   IN: <ctlWind = pointer to window.
2244 432E              ;
2245 432E              ;  OUT: Window title handle unlocked if it is a handle.
2246 432E              ;
2247 432E              unlockTitle PROC 
2248 432E              ;
2249 432E A0 D6 00              ldy   #wTitle+2                Is title a handle?
2250 4331 B7 01                 lda   [<ctlWind],y
2251 4333 10 1C                 bpl   @exit
2252 4335              ;
2253 4335 D4 1D                 pei   <cWork+2                 Save.
2254 4337 D4 1B                 pei   <cWork
2255 4339              ;
2256 4339 85 1D                 sta   <cWork+2
2257 433B 88                    dey   
2258 433C 88                    dey   
2259 433D B7 01                 lda   [<ctlWind],y
2260 433F 85 1B                 sta   <cWork
2261 4341              ;
2262 4341 A0 04 00              ldy   #4                       Unlock the title.
2263 4344 B7 1B                 lda   [<cWork],y
2264 4346 29 FF 7F              and   #$7FFF
2265 4349 97 1B                 sta   [<cWork],y
2266 434B              ;
2267 434B FA                    plx                            Restore.
2268 434C 86 1B                 stx   <cWork
2269 434E FA                    plx   
2270 434F 86 1D                 stx   <cWork+2
2271 4351
2272 4351 60           @exit    rts   
2273 4352                       ENDP 
2274 4352              ;
2275 4352              ;
2276 4352                       END   
2277 4352              ;
2278 4352              ;
